<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>New Mpox Variant Detected in England as Health Officials Step Up Monitoring</title>
    <meta name="title" content="New Mpox Variant Detected in England as Health Officials Step Up Monitoring">

    <!-- Meta Description -->
    <meta name="description"
        content="A new mpox variant has been detected in England, prompting increased monitoring as health officials stress vigilance and vaccination.">

        <meta name="author" content="Lydia Prescott">
    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring">

    <!-- Open Graph -->
    <meta property="og:title" content="New Mpox Variant Detected in England as Health Officials Step Up Monitoring">
    <meta property="og:description"
        content="Health officials in England detect a new mpox variant, stepping up monitoring while stressing continued surveillance and vaccination.">
    <meta property="og:url"
        content="https://www.morenews.org/health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring">
    <meta property="og:image"
        content="https://www.morenews.org/images/new-mpox-variant-detected-in-england-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="New Mpox Variant Detected in England as Health Officials Step Up Monitoring">
    <meta name="twitter:description"
        content="A newly detected mpox variant in England prompts increased monitoring, with officials urging awareness and vigilance.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/new-mpox-variant-detected-in-england-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <!-- JSON-LD -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/lydia-prescott#author",
      "name": "Lydia Prescott",
      "url": "https://www.morenews.org/author/lydia-prescott",
      "jobTitle": "Health Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Health",
          "item": "https://www.morenews.org/health/health"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "New Mpox Variant Detected in England as Health Officials Step Up Monitoring",
          "item": "https://www.morenews.org/health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring#webpage",
      "url": "https://www.morenews.org/health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring",
      "name": "New Mpox Variant Detected in England as Health Officials Step Up Monitoring",
      "description": "A newly detected mpox variant in England has prompted increased monitoring as officials stress vigilance and vaccination.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/new-mpox-variant-detected-in-england-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring#article",
      "headline": "New Mpox Variant Detected in England as Health Officials Step Up Monitoring",
      "description": "Health officials in England have identified a new mpox variant, stepping up monitoring and urging continued public vigilance.",
      "datePublished": "2025-12-13",
      "dateModified": "2025-12-13",
      "articleSection": "Health",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/lydia-prescott#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/new-mpox-variant-detected-in-england-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring#webpage"
      }
    }

  ]
}
</script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>

</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
New Mpox Variant Detected in England as Health Officials Step Up Monitoring
            </h1>

            <div class="article-breadcrumb">
                <a href="../health/health.php" title="health" class="crumb-link">Health</a> ›
                <span class="crumb-current">New Mpox Variant Detected in England as Health Officials Step Up Monitoring</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>

            <div class="writer-block">
            <div class="author-info">
                <?php include '../health-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-13">Published Date: 13 December 2025</div>
            </div>
            
            
        </div>
        <div class="image-wrapper">
            <img src="../images/new-mpox-variant-detected-in-england-first-image.webp" alt="New Mpox Variant Detected in England as Health Officials Step Up Monitoring first image">
        </div>
        <div class="writer-block">


            <div class="story-text-wrap">
                
                <p>
                    Health officials in England have identified a newly evolved variant of mpox, prompting renewed surveillance efforts and a fresh push to protect people most at risk, amid concerns about ongoing transmission.
                </p>

                <p>
                   The UK Health Security Agency (UKHSA) confirmed this week that the variant was detected through routine genomic monitoring, part of the country’s expanded disease surveillance system introduced after the Covid-19 pandemic. While officials stress that there is no immediate cause for alarm, they say the discovery underlines the need for continued vigilance.
                </p>
                <p>
                Mpox, which used to be called monkeypox, is a virus that spreads mostly through close physical contact.   The most common symptoms are fever, muscle aches, and a rash that looks like a rash. However, the severity of these symptoms can vary.   In 2022, the virus got international attention after outbreaks were reported in many parts of Europe, including the UK.
             </p>
                <p>
                According to health authorities, early analysis suggests the newly identified strain does not appear to cause more severe illness than existing variants. However, experts are still assessing whether it may spread more easily or evade some immune protection. “This is precisely why genomic surveillance matters,” a UKHSA spokesperson said. “Detecting changes early allows us to respond proportionately and protect public health.”
            </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/new-mpox-variant-detected-in-england-second-image.webp" alt="New Mpox Variant Detected in England as Health Officials Step Up Monitoring second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
                   Vaccination programmes targeting high-risk groups, including some healthcare workers and individuals with higher exposure risk, remain a key part of the UK’s strategy. Officials have reiterated that vaccines currently in use are expected to offer protection against the new variant, though further testing is under way.
                </p>

                <p>
                   Public health leaders are also urging people to be aware of symptoms and to seek medical advice if they develop unexplained rashes or flu-like illness following close contact with someone who is unwell. Those diagnosed are advised to isolate until lesions have healed to reduce the risk of transmission.
                </p>
                <p>
                    The detection comes as global health agencies continue to warn that mpox has not been eradicated and can resurface if surveillance weakens. International travel and close-contact social networks mean outbreaks can cross borders quickly without early intervention.
                </p>
                <p>
                    For now, officials say the risk to the general public remains low. But they emphasise that ongoing monitoring, vaccination uptake and clear public information will be essential in preventing wider spread. As one infectious disease expert noted, “Mpox is now a virus we understand far better — but that doesn’t mean we can afford to ignore it.”
                </p>
                <p>
                    Health authorities say updates will be issued if further findings emerge in the coming weeks.
                </p>
                </div>

        </div>
        
        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Health</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/nhs-faces-record-flu-surge-as-hospitals-brace-first-image.webp"
                        alt="NHS Faces Record Flu Surge as Hospitals Brace for ‘Worst-Case’ Winter Pressure first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../health/nhs-faces-record-flu-surge-as-hospitals-brace-for-worst-case-winter-pressure.php" title="NHS Faces Record Flu Surge as Hospitals Brace for ‘Worst-Case’ Winter Pressure" class="suggested-title">NHS Faces Record Flu Surge as Hospitals Brace for ‘Worst-Case’ Winter Pressure</a>
                        <span class="suggested-date">13 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/king-charles-says-cancer-treatment-will-be-reduced-first-image.webp"
                        alt="King Charles III Says Cancer Treatment Will Be Reduced After Positive Progress first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../health/king-charles-says-cancer-treatment-will-be-reduced-after-positive-progress.php" title="King Charles III Says Cancer Treatment Will Be Reduced After Positive Progress" class="suggested-title">King Charles III Says Cancer Treatment Will Be Reduced After Positive Progress</a>
                        <span class="suggested-date">14 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/uk-watchdog-bans-misleading-health-ads-first-image.webp"
                            alt="UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../health/uk-watchdog-bans-misleading-health-ads-claiming-to-treat-adhd-and-autism.php" title="UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism" class="suggested-title">UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism</a>
                        <span class="suggested-date">15 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>


    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>