<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>Whitbread Warns Property Tax Rises Could Cost Millions</title>
    <meta name="title" content="Whitbread Warns Property Tax Rises Could Cost Millions">

    <!-- Meta Description -->
    <meta name="description"
        content="Whitbread warns that rising property taxes linked to the UK budget could add tens of millions in costs, increasing pressure on hospitality firms.">

    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget">

        <meta name="author" content="Henry Whitaker">

    <!-- Open Graph -->
    <meta property="og:title" content="Whitbread Warns Property Tax Rises Could Cost Millions">
    <meta property="og:description"
        content="Whitbread says higher property taxes from the UK budget could add £40–50m in costs, raising concerns across the hospitality sector.">
    <meta property="og:url"
        content="https://www.morenews.org/business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget">
    <meta property="og:image"
        content="https://www.morenews.org/images/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Whitbread Warns Property Tax Rises Could Cost Millions">
    <meta name="twitter:description"
        content="Whitbread warns that higher UK property taxes could add tens of millions in costs, increasing pressure on hotels and hospitality firms.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Fonts -->
        <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/henry-whitaker#author",
      "name": "Henry Whitaker",
      "url": "https://www.morenews.org/author/henry-whitaker",
      "jobTitle": "Business Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Business",
          "item": "https://www.morenews.org/business/business"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Whitbread Warns Property Tax Rises Could Cost Millions",
          "item": "https://www.morenews.org/business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget#webpage",
      "url": "https://www.morenews.org/business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget",
      "name": "Whitbread Warns Property Tax Rises Could Cost Millions",
      "description": "Whitbread warns that rising property taxes linked to the UK budget could add tens of millions in costs, increasing pressure on hospitality firms.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget#article",
      "headline": "Whitbread Warns Property Tax Rises Could Cost Millions",
      "description": "Whitbread says higher property taxes from the UK budget could add £40–50 million in costs, raising concerns across the hospitality sector.",
      "datePublished": "2025-12-05",
      "dateModified": "2025-12-05",
      "articleSection": "Business",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/henry-whitaker#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget#webpage"
      }
    }

  ]
}
</script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>


</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               Whitbread warns that a rise in property taxes linked to the budget might cost millions of dollars
            </h1>

            <div class="article-breadcrumb">
                <a href="../business/business.php" title="business" class="crumb-link">Business</a> ›
                <span class="crumb-current">Whitbread warns that a rise in property taxes linked to the budget might cost millions of dollars</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../business-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-05">Published Date: 5 December 2025</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget-first-image.webp" alt="Whitbread warns that a rise in property taxes linked to the budget might cost millions of dollars first image">
        </div>
        <div class="writer-block">
           

            <div class="story-text-wrap">
                
                <p>
                 Whitbread, the company that owns the Premier Inn hotel chain, has warned that changes to business rates bills for valuable commercial properties will cost it an extra £40 million to £50 million in the next fiscal year. This will make things even harder for a sector that is already having trouble with rising costs.
                </p>

                <p>
                 The company says that the increase is because the government has recently revalued commercial real estate, which has caused hotel prices to go up a lot in areas with a lot of business. Whitbread runs about 850 Premier Inn hotels in the UK, and many of them are affected by the higher taxes.
                </p>
                <p>
                According to executives, the increase comes at a bad time for the hospitality industry, which is still dealing with stubborn food and energy inflation, ongoing labor shortages, and wage increases that are meant to attract and keep workers. Even though consumer spending is slowing down, these pressures have made operating costs go up.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget-second-image.webp" alt="Whitbread warns that a rise in property taxes linked to the budget might cost millions of dollars second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
                   Whitbread said that even though hotel occupancy has been good, the company still has to deal with the effects of rising fixed costs at a time when many customers are becoming more price-conscious. It warned that if business rates keep going up, they could hurt future investments, especially in regional projects and renovations meant to increase room capacity and energy efficiency.
                </p>

                <p>
                  The group said it would keep talking to lawmakers and trade groups about making long-term changes to the business rates system. Many businesses say it is outdated and unfairly burdens property-heavy industries like retail and hospitality.
                </p>
                <p>
                  Analysts said Whitbread’s warning underlines the difficulties still facing the UK hospitality sector as it continues to rebuild after the pandemic. Rising supplier costs, higher borrowing rates and persistent recruitment challenges have created a far more volatile trading environment, raising concerns that additional tax pressures could deter future investment in the industry.
                </p>
                <p>
                   Whitbread has indicated that the increase in business rates will form a significant part of its financial outlook for 2025–26. The company is expected to set out further details of its cost-saving measures when it updates investors later in the year. 
                </p>
            </div>

        </div>


        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Business</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/retail-stocks-rise-following-small-store-business-rates-reform-first-image.webp"
                            alt="Retail Stocks Rise Following Small-Store Business-Rates Reform first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../business/retail-stocks-rise-following-small-store-business-rates-reform.php" title="Retail Stocks Rise Following Small-Store Business-Rates Reform" class="suggested-title">Retail Stocks Rise Following Small-Store Business-Rates Reform</a>
                        <span class="suggested-date">5 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-first-image.webp"
                            alt="UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines.php" title="UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines" class="suggested-title">UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines</a>
                        <span class="suggested-date">5 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/uk-mortgage-rates-edge-down-as-lenders-compete-for-buyers-first-image.webp" 
                        alt="UK Mortgage Rates Edge Down as Lenders Compete for Buyers first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../business/uk-mortgage-rates-edge-down-as-lenders-compete-for-buyers.php" title="UK Mortgage Rates Edge Down as Lenders Compete for Buyers" class="suggested-title">UK Mortgage Rates Edge Down as Lenders Compete for Buyers</a>
                        <span class="suggested-date">15 December 2025</span>
                    </div>
                </div>
            </div>

           
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>


    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>