<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>UK Companies Cut Jobs Fastest Since 2021 as Construction Slows</title>
    <meta name="title" content="UK Companies Cut Jobs Fastest Since 2021 as Construction Slows">

    <!-- Meta Description -->
    <meta name="description"
        content="UK firms cut jobs at the fastest pace since 2021 as construction activity drops sharply, highlighting growing economic uncertainty.">

    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines">
   <meta name="author" content="Henry Whitaker">
    <!-- Open Graph -->
    <meta property="og:title" content="UK Companies Cut Jobs Fastest Since 2021 as Construction Slows">
    <meta property="og:description"
        content="UK businesses reduce staff numbers at the fastest rate since 2021 while construction activity falls to pandemic-era levels.">
    <meta property="og:url"
        content="https://www.morenews.org/business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines">
    <meta property="og:image"
        content="https://www.morenews.org/images/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="UK Companies Cut Jobs Fastest Since 2021 as Construction Slows">
    <meta name="twitter:description"
        content="UK job cuts accelerate as construction activity declines, raising concerns about growth and business confidence.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Fonts -->
        <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/henry-whitaker#author",
      "name": "Henry Whitaker",
      "url": "https://www.morenews.org/author/henry-whitaker",
      "jobTitle": "Business Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Business",
          "item": "https://www.morenews.org/business/business"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines",
          "item": "https://www.morenews.org/business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines#webpage",
      "url": "https://www.morenews.org/business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines",
      "name": "UK Companies Cut Jobs Fastest Since 2021 as Construction Slows",
      "description": "UK firms cut jobs at the fastest pace since 2021 as construction activity drops sharply, highlighting growing economic uncertainty.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines#article",
      "headline": "UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines",
      "description": "UK businesses are cutting jobs at the fastest rate since 2021 as construction activity falls sharply amid economic uncertainty.",
      "datePublished": "2025-12-05",
      "dateModified": "2025-12-05",
      "articleSection": "Business",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/henry-whitaker#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines#webpage"
      }
    }

  ]
}
</script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>


</head>



<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
                UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines
            </h1>

            <div class="article-breadcrumb">
                <a href="../business/business.php" title="business" class="crumb-link">Business</a> ›
                <span class="crumb-current">UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../business-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-05">Published Date: 5 December 2025</div>
            </div>
            
            
        </div>
        <div class="image-wrapper">
            <img src="../images/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-first-image.webp" alt="UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines first image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">

                <p>
                 Recent data shows that UK businesses are firing workers at the fastest rate since 2021. This is because the economy is becoming more unstable and tax and fiscal policies are expected to change. The construction industry has been hit the hardest, with activity levels dropping to what they were like in the early days of the Covid-19 epidemic.
                </p>

                <p>
                 An S&P Global survey found that the construction purchasing managers' index dropped from 44.1 in October 2025 to 39.4 in November. The most recent report shows that commercial projects, civil engineering work, and homebuilding have all shrunk a lot. This is the biggest drop in output since May 2020. The drops in all three areas were the biggest in almost five years.
                </p>
                <p>
                Respondents to the survey reported weak client confidence, postponed investment decisions and a slowdown in new orders. Many firms also said they were reducing staff numbers and scaling back the use of subcontractors, reflecting broader efforts to cut costs as workloads shrink.
                </p>
                <p>
                   Across the wider economy, Bank of England data and other PMI indicators suggest businesses are reducing headcount at a pace not seen in more than four years. Companies have attributed job losses to rising wage bills, softer demand and uncertainty ahead of forthcoming government fiscal decisions. 
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-second-image.webp" alt="UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
                   Analysts warn that the mix of falling demand, delayed investment and a more unsettled economic outlook is creating increasingly difficult trading conditions, particularly for construction firms. They say the downturn raises concerns that upcoming tax and budget measures could weigh further on business confidence and delay major projects.
                </p>

                <p>
                  Construction companies appear to be holding back on new work until there is greater clarity on economic policy. The drop in new orders has been especially marked in infrastructure and housing, deepening fears about the sector’s prospects in the months ahead.
                </p>
                <p>
                  The drop in activity and workers happens at a bad time for the economy as a whole. Many businesses have already had problems with tighter budgets, higher costs, and inflationary pressures. As demand goes down, the chance of hiring and investment slowing down more broadly seems to be growing.
                </p>
                <p>
                  Economists say job cuts and reduced construction activity could continue unless conditions improve or the government introduces measures aimed at stabilising confidence. Some firms have already signalled they will be cautious about recruitment and capital spending until fiscal policy and consumer trends become clearer — a shift that could have long-term implications for growth, infrastructure development and the UK labour market.
                </p>
            </div>

        </div>


        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Business</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/uk-mortgage-rates-edge-down-as-lenders-compete-for-buyers-first-image.webp" 
                        alt="UK Mortgage Rates Edge Down as Lenders Compete for Buyers first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../business/uk-mortgage-rates-edge-down-as-lenders-compete-for-buyers.php" title="UK Mortgage Rates Edge Down as Lenders Compete for Buyers" class="suggested-title">UK Mortgage Rates Edge Down as Lenders Compete for Buyers</a>
                        <span class="suggested-date">15 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../julio-herrera-velutini/images/julio-herrera-velutini-global-banking-leadership-financial-oversight.webp"
                            alt="Julio Herrera Velutini: Leading Global Banking and Navigating Financial Oversight Challenges" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../business/julio-herrera-velutini-global-banking-leadership-financial-oversight.php" title="Julio Herrera Velutini: Leading Global Banking and Navigating Financial Oversight Challenges" class="suggested-title">Julio Herrera Velutini: Leading Global Banking and Navigating Financial Oversight Challenges</a>
                        <span class="suggested-date">9 January 2026</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/bt-introduces-the-sovereign-data-platform-first-image.webp"
                            alt="BT Introduces the Sovereign Data Platform to Fulfill the Needs of the UK Digital Infrastructure" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../business/bt-introduces-the-sovereign-data-platform-to-fulfill-the-needs-of-the-uk-digital-infrastructure.php" title="BT Introduces the Sovereign Data Platform to Fulfill the Needs of the UKs Digital Infrastructure" class="suggested-title">BT Introduces the "Sovereign Data" Platform to Fulfill the Needs of the UK's Digital Infrastructure</a>
                        <span class="suggested-date">5 December 2025</span>
                    </div>
                </div>

            </div>

            
        </div>

<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>