
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title -->
    <title>Oliver Grant – Technology Journalist at More News</title>

    <!-- Meta Description -->
    <meta name="description" content="Read technology reporting by Oliver Grant covering AI, defence tech, innovation, digital policy and emerging technologies shaping business and society.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/author/oliver-grant">

    <!-- Open Graph -->
    <meta property="og:title" content="Oliver Grant – Technology Journalist at More News">
    <meta property="og:description" content="Read technology reporting by Oliver Grant covering AI, defence tech, innovation, digital policy and emerging technologies shaping business and society.">
    <meta property="og:url" content="https://www.morenews.org/author/oliver-grant">
    <meta property="og:image" content="https://www.morenews.org/images/oliver-grant.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:locale" content="en_GB">
    <meta property="og:type" content="profile">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Oliver Grant – Technology Journalist at More News">
    <meta name="twitter:description" content="Read technology reporting by Oliver Grant covering AI, defence tech, innovation, digital policy and emerging technologies shaping business and society.">
    <meta name="twitter:url" content="https://www.morenews.org/author/oliver-grant">
    <meta name="twitter:image" content="https://www.morenews.org/images/oliver-grant.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Fonts -->
        <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>


    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <!-- Structured Data -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@graph": [

        {
          "@type": "BreadcrumbList",
          "@id": "https://www.morenews.org/author/oliver-grant#breadcrumb",
          "itemListElement": [
            { "@type": "ListItem", "position": 1, "name": "Home", "item": "https://www.morenews.org/" },
            { "@type": "ListItem", "position": 2, "name": "Authors", "item": "https://www.morenews.org/authors" },
            { "@type": "ListItem", "position": 3, "name": "Oliver Grant", "item": "https://www.morenews.org/author/oliver-grant" }
          ]
        },

        {
          "@type": "NewsMediaOrganization",
          "@id": "https://www.morenews.org/#publisher",
          "name": "More News",
          "url": "https://www.morenews.org/",
          "logo": {
            "@type": "ImageObject",
            "url": "https://www.morenews.org/images/logo.webp",
            "width": 512,
            "height": 512
          },
          "address": {
            "@type": "PostalAddress",
            "addressCountry": "GB"
          }
        },

        {
          "@type": "Person",
          "@id": "https://www.morenews.org/author/oliver-grant#author",
          "name": "Oliver Grant",
          "jobTitle": "Technology Reporter",
          "description": "Technology journalist covering AI, defence tech, innovation and digital policy.",
          "url": "https://www.morenews.org/author/oliver-grant",
          "image": "https://www.morenews.org/images/oliver-grant.webp",
          "worksFor": { "@id": "https://www.morenews.org/#publisher" }
        },

        {
          "@type": "WebPage",
          "@id": "https://www.morenews.org/author/oliver-grant#webpage",
          "name": "Oliver Grant – Technology Journalist at More News",
          "description": "Read technology reporting by Oliver Grant covering AI, defence tech, innovation and digital policy at More News.",
          "url": "https://www.morenews.org/author/oliver-grant",
          "inLanguage": "en-GB",
          "mainEntity": { "@id": "https://www.morenews.org/author/oliver-grant#author" },
          "dateModified": "2025-12-12"
        },

        {
          "@type": "ItemList",
          "@id": "https://www.morenews.org/author/oliver-grant#articles",
          "name": "Articles by Oliver Grant",
          "itemListOrder": "Descending",
          "itemListElement": [
            {
              "@type": "ListItem",
              "position": 1,
              "url": "https://www.morenews.org/tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy"
            },
            {
              "@type": "ListItem",
              "position": 2,
              "url": "https://www.morenews.org/tech/ai-adoption-slashes-workloads-at-uk-firms"
            },
            {
              "@type": "ListItem",
              "position": 3,
              "url": "https://www.morenews.org/tech/nhs-trials-next-generation-medical-technologies-from-ai-diagnostics"
            },
            {
              "@type": "ListItem",
              "position": 4,
              "url": "https://www.morenews.org/tech/uk-defence-tech-accelerates-with-breakthroughn-in-robotics"
            }
          ]
        }

      ]
    }
    </script>

</head>


<body>
    <!-- header -->
<?php include '../header.php'; ?>

    <div class="main-container">
        <main>
        <section class="headline-rail">
            

        </section>
        <!-- HTML -->
        <section class="bio-panel">
            <div class="bio-container">
                <div class="bio-photo">
                    <img src="../images/oliver-grant.webp"
                        alt="Oliver Grant">
                </div>
                
                <div class="bio-details">
                    <h1 class="bio-name">Oliver Grant</h1>
                    <p class="bio-text">
                        Oliver Grant is a technology journalist covering the latest developments in tech trends, innovation and digital policy, with a focus on how new technologies impact business and society.
                    </p>
                </div>
                <div class="share-icons">
                    <a href="https://www.quora.com/profile/Oliver-Grant-134" title="quora" class="share-btn"><i class="fa-brands fa-quora" style="color: #000000;"></i></i></a>
                    <a href="https://flipboard.com/@olivergrant67" title="flipboard" class="share-btn"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a>
                    <a href="https://medium.com/@olivergrant_7852" title="medium" class="share-btn"><img src="../images/medium.webp" alt="medium" height="20px" width="20px"></i></i></a>
                    <a href="https://substack.com/@olivergrant27" title="substack" class="share-btn"><img src="../images/substack.webp" alt="substack" height="20px" width="20px"></a>
                </div>
            </div>
        </section>

<h2 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">Oliver Grant is a technology journalist covering </h2>
<h3 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">technology</h3>     



        <!-- Content + Sidebar -->
        <div class="news-flexzone">

            <!-- News List -->
            <div class="news-listcol">

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy.php" title="MBDA UK wins £316 million contract for laser-based anti-drone technology for the Royal Navy" >MBDA UK wins £316 million contract for laser-based anti-drone technology for the Royal Navy</a>
                        <p>The UK government has awarded MBDA UK a £316 million contract to deliver the first operational DragonFire laser weapon system, a major step in strengthening the Royal Navy’s ability to counter drone threats using low-cost, next-generation technology.</p>
                    </div>
                    <div class="news-imgpart">
                        <img src="../images/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology.webp"
                            alt="MBDA UK wins £316 million contract for laser-based anti-drone technology for the Royal Navy">
                    </div>
                </div>

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../tech/ai-adoption-slashes-workloads-at-uk-firms.php"
                             title="AI adoption slashes workloads at UK firms – and may offer a long-awaited boost to national productivity" >AI adoption slashes workloads at UK firms – and may offer a long-awaited boost to national productivity</a>
                        <p>UK firms are seeing dramatic productivity gains from AI adoption, with companies like Moore Kingston Smith cutting weeks of routine work down to hours and freeing staff to focus on higher-value, judgement-based tasks.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/ai-adoption-slashes-workloads-at-uk-firms-first-image.webp"
                            alt="AI adoption slashes workloads at UK firms – and may offer a long-awaited boost to national productivity">
                    </div>
                </div>

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../tech/nhs-trials-next-generation-medical-technologies-from-ai-diagnostics.php" 
                            title="NHS Trials Next-Generation Medical Technologies, from AI Diagnostics to 3D Imaging" >NHS Trials Next-Generation Medical Technologies, from AI Diagnostics to 3D Imaging</a>
                        <p>NHS hospitals are rolling out new technologies such as AI diagnostics and 3D imaging to speed up diagnosis, personalise care and ease pressure on staff.
                        </p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/nhs-trials-next-generation-medical-technologies-from-ai-diagnostics-first-image.webp"
                            alt="NHS Trials Next-Generation Medical Technologies, from AI Diagnostics to 3D Imaging first iamge">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../tech/uk-defence-tech-accelerates-with-breakthroughn-in-robotics.php"
                             title="UK Defence Tech Accelerates with Breakthroughs in Robotics, Undersea Systems and AI" >UK Defence Tech Accelerates with Breakthroughs in Robotics, Undersea Systems and AI</a>
                        <p>The UK is stepping up investment in AI, robotics and autonomous underwater technology through its new Atlantic Bastion programme, as it looks to better protect vital maritime infrastructure in an increasingly tense global security environment.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/uk-defence-tech-accelerates-with-breakthroughn-in-robotics-first-image.webp"
                            alt="UK Defence Tech Accelerates with Breakthroughs in Robotics, Undersea Systems and AI first image">
                    </div>
                </div>
                
            </div>

            <!-- Sidebar -->
            <div class="side-railbox">
                <div class="side-adunit">
                    <!-- <div class="sponsor-note">- A Word From Our Sponsors -</div> -->
                    <a href="https://www.venture-hive.com/" title="venture hive"><img loading="lazy" src="../images/venture-hive.webp"
                        alt="venture-hive"></a>
                </div>
                <div class="side-socialpanel">
                    <h4>Follow Us</h4>
                    <ul>
                        <li><a href="https://x.com/More_NewsMN" title="Twitter"><i class="fa-brands fa-x-twitter" style="color: #000000;"></i></a></li>
                        <li><a href="https://www.instagram.com/morewnews_/" title="instagram"><img src="../images/instagram.webp" alt="instagram" height="20px" width="20px"></a></li>
                        
                        <li><a href="https://www.quora.com/profile/More-News-6" title="Quora"><i class="fa-brands fa-quora" style="color: #000000;"></i></a></li>
                        <li><a href="https://flipboard.com/@more_news" title="Flipboard"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a></li>
                        <li><a href="https://medium.com/@more_news" title="Medium"><img src="../images/medium.webp" alt="Medium" height="20px" width="20px"></a></li>
                        <li><a href="https://substack.com/@morenewsmn" title="Substack"><img src="../images/substack.webp" alt="Substack" height="19px" width="19px"></a></li>
                    </ul>

                </div>
            </div>

        </div>
       </main>
        <!-- footer -->
<?php include '../footer.php'; ?>
    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>