<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title (55 characters) -->
    <title>James Thornton – UK News Reporter at More News</title>

    <!-- Meta Description (155 characters) -->
    <meta name="description" content="Read the latest UK political and social reporting by James Thornton, covering government policy, public affairs and major national developments at More News.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/author/james-thornton">

    <!-- Open Graph -->
    <meta property="og:title" content="James Thornton – UK News Reporter at More News">
    <meta property="og:description" content="Read the latest UK political and social reporting by James Thornton, covering government policy, public affairs and major national developments at More News.">
    <meta property="og:url" content="https://www.morenews.org/author/james-thornton">
    <meta property="og:image" content="https://www.morenews.org/images/james-thornton.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:locale" content="en_GB">
    <meta property="og:type" content="profile">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="James Thornton – UK News Reporter at More News">
    <meta name="twitter:description" content="Read the latest UK political and social reporting by James Thornton, covering government policy, public affairs and major national developments at More News.">
    <meta name="twitter:url" content="https://www.morenews.org/author/james-thornton">
    <meta name="twitter:image" content="https://www.morenews.org/images/james-thornton.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Fonts -->
    <link rel="stylesheet" href="../css/style.css">
        <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>


    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <!-- Structured Data -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@graph": [

        {
          "@type": "BreadcrumbList",
          "@id": "https://www.morenews.org/author/james-thornton#breadcrumb",
          "itemListElement": [
            { "@type": "ListItem", "position": 1, "name": "Home", "item": "https://www.morenews.org/" },
            { "@type": "ListItem", "position": 2, "name": "Authors", "item": "https://www.morenews.org/authors" },
            { "@type": "ListItem", "position": 3, "name": "James Thornton", "item": "https://www.morenews.org/author/james-thornton" }
          ]
        },

        {
          "@type": "NewsMediaOrganization",
          "@id": "https://www.morenews.org/#publisher",
          "name": "More News",
          "url": "https://www.morenews.org/",
          "logo": {
            "@type": "ImageObject",
            "url": "https://www.morenews.org/images/logo.webp",
            "width": 512,
            "height": 512
          },
          "address": {
            "@type": "PostalAddress",
            "addressCountry": "GB"
          }
        },

        {
          "@type": "Person",
          "@id": "https://www.morenews.org/author/james-thornton#author",
          "name": "James Thornton",
          "jobTitle": "UK Reporter",
          "description": "UK journalist covering politics, public affairs and social issues.",
          "url": "https://www.morenews.org/author/james-thornton",
          "image": "https://www.morenews.org/images/james-thornton.webp",
          "worksFor": { "@id": "https://www.morenews.org/#publisher" }
        },

        {
          "@type": "WebPage",
          "@id": "https://www.morenews.org/author/james-thornton#webpage",
          "name": "James Thornton – UK News Reporter at More News",
          "description": "Read the latest UK political and social reporting by James Thornton at More News.",
          "url": "https://www.morenews.org/author/james-thornton",
          "inLanguage": "en-GB",
          "mainEntity": { "@id": "https://www.morenews.org/author/james-thornton#author" }
        },

        {
          "@type": "ItemList",
          "@id": "https://www.morenews.org/author/james-thornton#articles",
          "name": "Articles by James Thornton",
          "itemListOrder": "Descending",
          "itemListElement": [
            { "@type": "ListItem", "position": 1, "url": "https://www.morenews.org/uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet" },
            { "@type": "ListItem", "position": 2, "url": "https://www.morenews.org/uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men" },
            { "@type": "ListItem", "position": 3, "url": "https://www.morenews.org/uk/whats-new-in-this-months-redesigned-uk-passports" },
            { "@type": "ListItem", "position": 4, "url": "https://www.morenews.org/uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters" },
            { "@type": "ListItem", "position": 5, "url": "https://www.morenews.org/uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators" },
            { "@type": "ListItem", "position": 6, "url": "https://www.morenews.org/uk/us-and-uk-agree-to-zero-pharmaceutical-tariffs" },
            { "@type": "ListItem", "position": 7, "url": "https://www.morenews.org/uk/uk-wanted-to-rejoin-erasmus-student-exchange" },
            { "@type": "ListItem", "position": 8, "url": "https://www.morenews.org/uk/uk-rail-strike-talks-resume-as-christmas-travel-disruption-looms" },
            { "@type": "ListItem", "position": 9, "url": "https://www.morenews.org/uk/trump-greenland-remarks-uk-nato-concern" }
          ]
        }

      ]
    }
    </script>
</head>



<body>
    <!-- header -->
<?php include '../header.php'; ?>

    <div class="main-container">
        <main>
        <section class="headline-rail">
            

        </section>
        <!-- HTML -->
        <section class="bio-panel">
            <div class="bio-container">
                <div class="bio-photo">
                    <img src="../images/james-thornton.webp"
                        alt="James Thornton">
                </div>
                
                <div class="bio-details">
                    <h1 class="bio-name">James Thornton</h1>
                    <p class="bio-text">
                        James Thornton is a British news reporter who writes about politics, social issues, and current events. His goal is to cover and analyze events that have an impact on daily life in the UK in a way that is timely, accurate, and easy to understand.
                    </p>
                </div>
                <div class="share-icons">
                    <a href="https://www.quora.com/profile/James-Thornton-497" title="quora" class="share-btn"><i class="fa-brands fa-quora" style="color: #000000;"></i></i></a>
                    <a href="https://flipboard.com/@jamesthornt" title="flipboard" class="share-btn"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a>
                    <a href="https://medium.com/@jamesthornton_83175" title="medium" class="share-btn"><img src="../images/medium.webp" alt="medium" height="20px" width="20px"></i></i></a>
                    <a href="https://substack.com/@jamesthornton47" title="substack" class="share-btn"><img src="../images/substack.webp" alt="substack" height="20px" width="20px"></a>
                </div>
            </div>
        </section>
<h2 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">James Thornton is a British news reporter</h2>
<h3 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">British news reporter</h3>     


        <!-- Content + Sidebar -->
        <div class="news-flexzone">

            <!-- News List -->
            <div class="news-listcol">

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet.php" title="Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet">Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet</a>
                        <p>PM’s chief secretary denies any lying as Reeves faces claims she hid OBR surplus forecasts.</p>
                    </div>
                    <div class="news-imgpart">
                        <img src="../images/darren-jones-defends-rachel-reeves-for-misrepresenting-first-image.webp"
                        alt="Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet">
                    </div>
                </div>

                

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php" title="UK special forces accused of policy to kill Afghan fighting-age men">UK special forces accused of policy to kill Afghan fighting-age men</a>
                        <p>According to a senior commander, he alerted the leadership of the UK special forces, but they "consciously decided" to conceal it.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/uk-special-forces-accused-of-policy-to-kill-afghan-first-image.webp"
                            alt="UK special forces accused of policy to kill Afghan fighting-age men">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../uk/whats-new-in-this-months-redesigned-uk-passports.php" title="What’s new in this month’s redesigned UK passports?">What’s new in this month’s redesigned UK passports?</a>
                        <p>The Home Office says this is the first fully new UK passport design in five years. Here are the key changes and their impact.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/whats-new-in-this-months-redesigned-uk-passports-first-image.webp"
                            alt="What’s new in this month’s redesigned UK passports?">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters.php" title="Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is proud of the budget">Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is "proud" of the budget</a>
                        <p>Sir Keir Starmer backed Rachel Reeves’ disputed budget, dismissing claims of misleading figures and calling for an honest reckoning on Brexit and closer ties with the EU.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/starmer-reeves-the-pm-denies-misleading-the-cabinet-first-image.webp"
                            alt="Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is proud of the budget">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators.php" title="When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators">When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators</a>
                        <p>Revolut came under regulatory scrutiny after documents showed CEO Nik Storonsky lives in the UAE, a move the company did not initially disclose while seeking a UK banking licence.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators-first-image.webp"
                         alt="When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../uk/us-and-uk-agree-to-zero-pharmaceutical-tariffs.php" title="US and UK agree to zero pharmaceutical tariffs">US and UK agree to zero pharmaceutical tariffs<</a>
                        <p>The UK agreed to increase NHS drug spending and tighten approval rules in return for a three-year pause on US tariffs on British medicines, a move the government says protects a key export sector but critics warn could cost the NHS billions.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/us-and-uk-agree-to-zero-pharmaceutical-tariffs-first-image.webp"
                         alt="US and UK agree to zero pharmaceutical tariffs first image">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../uk/uk-wanted-to-rejoin-erasmus-student-exchange.php" title="UK wanted to rejoin Erasmus student exchange">UK wanted to rejoin Erasmus student exchange</a>
                        <p>The UK is expected to agree in January to rejoin the Erasmus programme from 2027 as part of efforts to reset post-Brexit relations, while France may challenge Britain’s foie gras import ban amid stalled talks on wider cooperation.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/uk-wanted-to-rejoin-erasmus-student-exchange-first-image.webp" 
                        alt="UK wanted to rejoin Erasmus student exchange first image">
                    </div>
                </div>
                
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../uk/uk-rail-strike-talks-resume-as-christmas-travel-disruption-looms.php" title="UK Rail Strike Talks Resume as Christmas Travel Disruption Looms">UK Rail Strike Talks Resume as Christmas Travel Disruption Looms</a>
                        <p>Rail unions and train operators have resumed talks as fears grow that renewed strike action could disrupt Christmas and New Year travel, with progress reported on working practices but major disputes over pay and job security still unresolved.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/uk-rail-strike-talks-resume-as-christmas-travel-disruption-looms-first-image.webp"
                    alt="UK Rail Strike Talks Resume as Christmas Travel Disruption Looms first image">
                    </div>
                </div>

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../uk/trump-greenland-remarks-uk-nato-concern.php" title="Trump’s Greenland Remarks Spark UK and NATO Concern as Allies Urge Restraint">Trump’s Greenland Remarks Spark UK and NATO Concern as Allies Urge Restraint</a>
                        <p>Rail unions and train operators resume negotiations as pressure mounts to avoid strike action that could disrupt Christmas and New Year travel across the UK.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/trump-greenland-remarks-uk-nato-concern.webp"
                    alt="Trump’s Greenland Remarks Spark UK and NATO Concern as Allies Urge Restraint">
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="side-railbox">
                <div class="side-adunit">
                    <!-- <div class="sponsor-note">- A Word From Our Sponsors -</div> -->
                    <a href="https://www.venture-hive.com/" title="venture hive"><img loading="lazy" src="../images/venture-hive.webp"
                        alt="venture-hive"></a>
                </div>
                <div class="side-socialpanel">
                    <h4>Follow Us</h4>
                    <ul>
                        <li><a href="https://x.com/More_NewsMN" title="Twitter"><i class="fa-brands fa-x-twitter" style="color: #000000;"></i></a></li>
                        <li><a href="https://www.instagram.com/morewnews_/" title="instagram"><img src="../images/instagram.webp" alt="instagram" height="20px" width="20px"></a></li>
                        
                        <li><a href="https://www.quora.com/profile/More-News-6" title="Quora"><i class="fa-brands fa-quora" style="color: #000000;"></i></a></li>
                        <li><a href="https://flipboard.com/@more_news" title="Flipboard"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a></li>
                        <li><a href="https://medium.com/@more_news" title="Medium"><img src="../images/medium.webp" alt="Medium" height="20px" width="20px"></a></li>
                        <li><a href="https://substack.com/@morenewsmn" title="Substack"><img src="../images/substack.webp" alt="Substack" height="19px" width="19px"></a></li>
                    </ul>

                </div>
            </div>

        </div>
        </main>
        <!-- footer -->
<?php include '../footer.php'; ?>
    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>