
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title (55 characters exact) -->
    <title>Henry Whitaker – Business Journalist at More News</title>

    <!-- Meta Description (155 characters exact) -->
    <meta name="description" content="Read business and finance reporting by Henry Whitaker, covering markets, corporate strategy, economic policy and global industry trends at More News.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/author/henry-whitaker">

    <!-- Open Graph -->
    <meta property="og:title" content="Henry Whitaker – Business Journalist at More News">
    <meta property="og:description" content="Read business and finance reporting by Henry Whitaker, covering markets, corporate strategy, economic policy and global industry trends at More News.">
    <meta property="og:url" content="https://www.morenews.org/author/henry-whitaker">
    <meta property="og:image" content="https://www.morenews.org/images/henry-whitaker.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:locale" content="en_GB">
    <meta property="og:type" content="profile">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Henry Whitaker – Business Journalist at More News">
    <meta name="twitter:description" content="Read business and finance reporting by Henry Whitaker, covering markets, corporate strategy, economic policy and global industry trends at More News.">
    <meta name="twitter:url" content="https://www.morenews.org/author/henry-whitaker">
    <meta name="twitter:image" content="https://www.morenews.org/images/henry-whitaker.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

        <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>


    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/author/henry-whitaker#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Authors",
          "item": "https://www.morenews.org/authors"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Henry Whitaker",
          "item": "https://www.morenews.org/author/henry-whitaker"
        }
      ]
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/henry-whitaker.php#author",
      "name": "Henry Whitaker",
      "description": "Business journalist covering markets, corporate strategy and economic policy.",
      "url": "https://www.morenews.org/author/henry-whitaker",
      "image": "https://www.morenews.org/images/henry-whitaker.webp",
      "jobTitle": "Business Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/author/henry-whitaker.php#webpage",
      "name": "Henry Whitaker – Business Journalist at More News",
      "description": "Read business and finance reporting by Henry Whitaker, covering markets, corporate strategy, economic policy and global industry trends at More News.",
      "url": "https://www.morenews.org/author/henry-whitaker",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "mainEntity": {
        "@id": "https://www.morenews.org/author/henry-whitaker.php#author"
      },
      "dateModified": "2025-12-12"
    },

    {
      "@type": "ItemList",
      "@id": "https://www.morenews.org/author/henry-whitaker.php#articles",
      "name": "Articles by Henry Whitaker",
      "itemListOrder": "Descending",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.morenews.org/business/bt-introduces-the-sovereign-data-platform-to-fulfill-the-needs-of-the-uk-digital-infrastructure"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.morenews.org/business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.morenews.org/business/retail-stocks-rise-following-small-store-business-rates-reform"
        },
        {
          "@type": "ListItem",
          "position": 4,
          "url": "https://www.morenews.org/business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines"
        },
        {
          "@type": "ListItem",
          "position": 5,
          "url": "https://www.morenews.org/business/uk-mortgage-rates-edge-down-as-lenders-compete-for-buyers"
        },
        {
          "@type": "ListItem",
          "position": 6,
          "url": "https://www.morenews.org/business/julio-herrera-velutini-global-banking-leadership-financial-oversight"
        }
      ]
    }

  ]
}
</script>

</head>


<body>
    <!-- header -->
<?php include '../header.php'; ?>

    <div class="main-container">
        <main>
        <section class="headline-rail">
            

        </section>
        <!-- HTML -->
        <section class="bio-panel">
            <div class="bio-container">
                <div class="bio-photo">
                    <img src="../images/henry-whitaker.webp"
                        alt="Henry Whitaker">
                </div>
                
                <div class="bio-details">
                    <h1 class="bio-name">Henry Whitaker</h1>
                    <p class="bio-text">
                        Henry Whitaker is a business journalist covering market trends, corporate strategy and economic policy. His reporting focuses on providing clear insight into global finance and industrial developments.
                    </p>
                </div>
                <div class="share-icons">
                    <a href="https://www.quora.com/profile/Henry-Whitaker-26" title="quora" class="share-btn"><i class="fa-brands fa-quora" style="color: #000000;"></i></i></a>
                    <a href="https://flipboard.com/@henrywhitak" title="flipboard" class="share-btn"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a>
                    <a href="https://medium.com/@henrywhitaker_51059" title="medium" class="share-btn"><img src="../images/medium.webp" alt="medium" height="20px" width="20px"></i></i></a>
                    <a href="https://substack.com/@henrywhitaker57" title="substack" class="share-btn"><img src="../images/substack.webp" alt="substack" height="20px" width="20px"></a>
                </div>
            </div>
        </section>

<h2 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">Henry Whitaker is a business journalist</h2>
<h3 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">business journalist</h3>     



        <!-- Content + Sidebar -->
        <div class="news-flexzone">

            <!-- News List -->
            <div class="news-listcol">

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../business/bt-introduces-the-sovereign-data-platform-to-fulfill-the-needs-of-the-uk-digital-infrastructure.php" title="BT Introduces the Sovereign Data Platform to Fulfill the Needs of the UKs Digital Infrastructure">BT Introduces the "Sovereign Data" Platform to Fulfill the Needs of the UK's Digital Infrastructure</a>
                        <p>BT has unveiled a new sovereign data platform aimed at UK public-sector organisations and domestic businesses, designed to keep sensitive data stored and managed entirely within the UK as concerns over security, regulation and resilience continue to grow.</p>
                    </div>
                    <div class="news-imgpart">
                        <img src="../images/bt-introduces-the-sovereign-data-platform-first-image.webp"
                            alt="BT Introduces the Sovereign Data Platform to Fulfill the Needs of the UK Digital Infrastructure">
                    </div>
                </div>

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget.php" 
                            title="Whitbread warns that a rise in property taxes linked to the budget might cost millions of dollars">Whitbread warns that a rise in property taxes linked to the budget might cost millions of dollars</a>
                        <p>Whitbread has warned that changes to business rates could add £40 million to £50 million to its costs next year, adding further pressure on the hospitality sector as hotels face rising expenses and slowing consumer spending.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget-first-image.webp"
                            alt="Whitbread warns that a rise in property taxes linked to the budget might cost millions of dollars first image">
                    </div>
                </div>

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../business/retail-stocks-rise-following-small-store-business-rates-reform.php" title="Retail Stocks Rise Following Small-Store Business-Rates Reform">Retail Stocks Rise Following Small-Store Business-Rates Reform</a>
                        <p>UK retail shares rose after the government unveiled major business-rates reforms aimed at cutting costs for small shops, cafés and leisure businesses, while shifting more of the tax burden onto larger commercial properties.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/retail-stocks-rise-following-small-store-business-rates-reform-first-image.webp"
                            alt="Retail Stocks Rise Following Small-Store Business-Rates Reform first image">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines.php" title="UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines">
                                UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines</a>
                        <p>UK businesses are laying off workers at the fastest rate since 2021 because construction output is falling quickly because of weak demand, rising costs, and economic uncertainty.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-first-image.webp"
                            alt="UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../business/uk-mortgage-rates-edge-down-as-lenders-compete-for-buyers.php" title="UK Mortgage Rates Edge Down as Lenders Compete for Buyers">UK Mortgage Rates Edge Down as Lenders Compete for Buyers</a>
                        <p>UK companies are shedding jobs at the fastest rate in more than four years, with construction hit hardest as falling demand, rising costs and economic uncertainty push firms to cut staff and delay investment.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/uk-mortgage-rates-edge-down-as-lenders-compete-for-buyers-first-image.webp" 
                        alt="UK Mortgage Rates Edge Down as Lenders Compete for Buyers first image">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../business/julio-herrera-velutini-global-banking-leadership-financial-oversight.php" title="Julio Herrera Velutini: Leading Global Banking and Navigating Financial Oversight Challenges">Julio Herrera Velutini: Leading Global Banking and Navigating Financial Oversight Challenges</a>
                        <p>Julio Herrera Velutini is an international banker known for founding Bancrédito International Bank & Trust and leading Britannia Financial Group. With experience across Europe, Latin America, and the U.S., he specializes in global finance, wealth management, and navigating regulatory challenges.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../julio-herrera-velutini/images/julio-herrera-velutini-global-banking-leadership-financial-oversight.webp" 
                        alt="Julio Herrera Velutini: Leading Global Banking and Navigating Financial Oversight Challenges first image">
                    </div>
                </div>
                
                
            </div>

            <!-- Sidebar -->
            <div class="side-railbox">
                <div class="side-adunit">
                    <!-- <div class="sponsor-note">- A Word From Our Sponsors -</div> -->
                    <a href="https://www.venture-hive.com/" title="venture hive"><img loading="lazy" src="../images/venture-hive.webp"
                        alt="venture-hive"></a>
                </div>
                <div class="side-socialpanel">
                    <h4>Follow Us</h4>
                    <ul>
                        <li><a href="https://x.com/More_NewsMN" title="Twitter"><i class="fa-brands fa-x-twitter" style="color: #000000;"></i></a></li>
                        <li><a href="https://www.instagram.com/morewnews_/" title="instagram"><img src="../images/instagram.webp" alt="instagram" height="20px" width="20px"></a></li>
                        
                        <li><a href="https://www.quora.com/profile/More-News-6" title="Quora"><i class="fa-brands fa-quora" style="color: #000000;"></i></a></li>
                        <li><a href="https://flipboard.com/@more_news" title="Flipboard"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a></li>
                        <li><a href="https://medium.com/@more_news" title="Medium"><img src="../images/medium.webp" alt="Medium" height="20px" width="20px"></a></li>
                        <li><a href="https://substack.com/@morenewsmn" title="Substack"><img src="../images/substack.webp" alt="Substack" height="19px" width="19px"></a></li>
                    </ul>

                </div>
            </div>

        </div>
        </main>
        <!-- footer -->
<?php include '../footer.php'; ?>
    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>