
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

 <!-- SEO Title -->
<title>Grace Harrington – Business News Reporter at More News</title>

<!-- Meta Description -->
<meta name="description" content="Read business and economic reporting by Grace Harrington, covering markets, corporate strategy and economic policy at More News.">

<!-- Canonical -->
<link rel="canonical" href="https://www.morenews.org/author/grace-harrington">

<!-- Open Graph -->
<meta property="og:title" content="Grace Harrington – Business News Reporter at More News">
<meta property="og:description" content="Read business and economic reporting by Grace Harrington, covering markets, corporate strategy and economic policy at More News.">
<meta property="og:url" content="https://www.morenews.org/author/grace-harrington">
<meta property="og:image" content="https://www.morenews.org/images/grace-harrington.webp">
<meta property="og:site_name" content="More News">
<meta property="og:locale" content="en_GB">
<meta property="og:type" content="profile">

<!-- Twitter Cards -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Grace Harrington – Business News Reporter at More News">
<meta name="twitter:description" content="Read business and economic reporting by Grace Harrington, covering markets, corporate strategy and economic policy at More News.">
<meta name="twitter:url" content="https://www.morenews.org/author/grace-harrington">
<meta name="twitter:image" content="https://www.morenews.org/images/grace-harrington.webp">
<meta name="twitter:site" content="@morenews">
<meta name="twitter:creator" content="@morenews">


    <!-- Fonts -->
        <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>


    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <!-- Structured Data -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/author/grace-harrington#breadcrumb",
      "itemListElement": [
        { "@type": "ListItem", "position": 1, "name": "Home", "item": "https://www.morenews.org/" },
        { "@type": "ListItem", "position": 2, "name": "Authors", "item": "https://www.morenews.org/authors" },
        { "@type": "ListItem", "position": 3, "name": "Grace Harrington", "item": "https://www.morenews.org/author/grace-harrington" }
      ]
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/grace-harrington#author",
      "name": "Grace Harrington",
      "jobTitle": "Business News Reporter",
      "description": "UK journalist specialising in business news, covering corporate developments, markets and economic policy.",
      "url": "https://www.morenews.org/author/grace-harrington",
      "image": "https://www.morenews.org/images/grace-harrington.webp",
      "worksFor": { "@id": "https://www.morenews.org/#publisher" }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/author/grace-harrington#webpage",
      "name": "Grace Harrington – Business News Reporter at More News",
      "description": "Read business and economic reporting by Grace Harrington at More News.",
      "url": "https://www.morenews.org/author/grace-harrington",
      "inLanguage": "en-GB",
      "mainEntity": { "@id": "https://www.morenews.org/author/grace-harrington#author" },
      "dateModified": "2026-01-01"
    },

    {
      "@type": "ItemList",
      "@id": "https://www.morenews.org/author/grace-harrington#articles",
      "name": "Articles by Grace Harrington",
      "itemListOrder": "Descending",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.morenews.org/world/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate"
        }
      ]
    }

  ]
}
</script>


</head>


<body>
    <!-- header -->
<?php include '../header.php'; ?>

    <div class="main-container">
        <main>
        <section class="headline-rail">
            

        </section>
        <!-- HTML -->
        <section class="bio-panel">
            <div class="bio-container">
                <div class="bio-photo">
                    <img src="../images/grace-harrington.webp"
                        alt="Grace Harrington">
                </div>
                
                <div class="bio-details">
                    <h1 class="bio-name">Grace Harrington</h1>
                    <p class="bio-text">
                        Grace Harrington is a UK journalist specialising in business news, covering corporate developments, markets, and economic policy.</p>
                </div>
                <div class="share-icons">
                    <a href="https://x.com/graceharri95941" title="twitter" class="share-btn"><i class="fa-brands fa-x-twitter" style="color: #000000;"></i></a>
                    <a href="https://www.quora.com/profile/More-News-6" title="quora" class="share-btn"><i class="fa-brands fa-quora" style="color: #000000;"></i></i></a>
                    <a href="https://flipboard.com/@more_news" title="flipboard" class="share-btn"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a>
                    <a href="https://medium.com/@graceharrington_24147" title="medium" class="share-btn"><img src="../images/medium.webp" alt="medium" height="20px" width="20px"></i></i></a>
                    <a href="https://substack.com/@graceharrington95941" title="substack" class="share-btn"><img src="../images/substack.webp" alt="substack" height="20px" width="20px"></a>
                </div>
            </div>
        </section>

<h2 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">Grace Harrington is a UK journalist specialising</h2>
<h3 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">UK journalist</h3>     



        <!-- Content + Sidebar -->
        <div class="news-flexzone">

            <!-- News List -->
            <div class="news-listcol">

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../world/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate.php" title="IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate">IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate</a>
                        <p>The IOC says Russian and Belarusian youth athletes should be allowed to compete under their national flags, while senior-level restrictions remain.</p>
                    </div>
                    <div class="news-imgpart">
                        <img src="../images/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate-first-image.webp"
                            alt="IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate first image">
                    </div>
                </div>              
                
                
                
            </div>

            <!-- Sidebar -->
            <div class="side-railbox">
                <div class="side-adunit">
                    <!-- <div class="sponsor-note">- A Word From Our Sponsors -</div> -->
                    <a href="https://www.venture-hive.com/" title="venture hive"><img loading="lazy" src="../images/venture-hive.webp"
                        alt="venture-hive"></a>
                </div>
                <div class="side-socialpanel">
                    <h4>Follow Us</h4>
                    <ul>
                        <li><a href="https://x.com/More_NewsMN" title="Twitter"><i class="fa-brands fa-x-twitter" style="color: #000000;"></i></a></li>
                        <li><a href="https://www.instagram.com/morewnews_/" title="instagram"><img src="../images/instagram.webp" alt="instagram" height="20px" width="20px"></a></li>
                        
                        <li><a href="https://www.quora.com/profile/More-News-6" title="Quora"><i class="fa-brands fa-quora" style="color: #000000;"></i></a></li>
                        <li><a href="https://flipboard.com/@more_news" title="Flipboard"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a></li>
                        <li><a href="https://medium.com/@more_news" title="Medium"><img src="../images/medium.webp" alt="Medium" height="20px" width="20px"></a></li>
                        <li><a href="https://substack.com/@morenewsmn" title="Substack"><img src="../images/substack.webp" alt="Substack" height="19px" width="19px"></a></li>
                    </ul>

                </div>
            </div>

        </div>

        </main>
        <!-- footer -->
<?php include '../footer.php'; ?>
    </div>
    <button
  class="scrollup-btn"
  onclick="window.scrollTo({top:0, behavior:'smooth'});"
  aria-label="Scroll back to top">
</button>
        <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>

</body>

</html>