
<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title (55 characters exact) -->
    <title>Emily Hargreaves – Political Journalist at More News</title>

    <!-- Meta Description (155 characters exact) -->
    <meta name="description" content="Read political analysis and UK policy reporting by Emily Hargreaves, covering Westminster, government decisions and public affairs at More News.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/author/emily-hargreaves">

    <!-- Open Graph -->
    <meta property="og:title" content="Emily Hargreaves – Political Journalist at More News">
    <meta property="og:description" content="Read political analysis and UK policy reporting by Emily Hargreaves, covering Westminster, government decisions and public affairs at More News.">
    <meta property="og:url" content="https://www.morenews.org/author/emily-hargreaves">
    <meta property="og:image" content="https://www.morenews.org/images/emily-hargreaves.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:locale" content="en_GB">
    <meta property="og:type" content="profile">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Emily Hargreaves – Political Journalist at More News">
    <meta name="twitter:description" content="Read political analysis and UK policy reporting by Emily Hargreaves, covering Westminster, government decisions and public affairs at More News.">
    <meta name="twitter:url" content="https://www.morenews.org/author/emily-hargreaves">
    <meta name="twitter:image" content="https://www.morenews.org/images/emily-hargreaves.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

        <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>


    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/author/emily-hargreaves#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Authors",
          "item": "https://www.morenews.org/authors"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Emily Hargreaves",
          "item": "https://www.morenews.org/author/emily-hargreaves"
        }
      ]
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/emily-hargreaves#author",
      "name": "Emily Hargreaves",
      "description": "Political journalist covering UK politics, public policy and government affairs.",
      "url": "https://www.morenews.org/author/emily-hargreaves",
      "image": "https://www.morenews.org/images/emily-hargreaves.webp",
      "jobTitle": "Political Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/author/emily-hargreaves#webpage",
      "name": "Emily Hargreaves – Political Journalist at More News",
      "description": "Read political analysis and UK policy reporting by Emily Hargreaves, covering Westminster, government decisions and public affairs at More News.",
      "url": "https://www.morenews.org/author/emily-hargreaves",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "mainEntity": {
        "@id": "https://www.morenews.org/author/emily-hargreaves#author"
      },
      "dateModified": "2026-01-23"
    },

    {
      "@type": "ItemList",
      "@id": "https://www.morenews.org/author/emily-hargreaves#articles",
      "name": "Articles by Emily Hargreaves",
      "itemListOrder": "Descending",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.morenews.org/politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.morenews.org/politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.morenews.org/politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start"
        },
        {
          "@type": "ListItem",
          "position": 4,
          "url": "https://www.morenews.org/politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax"
        },
        {
          "@type": "ListItem",
          "position": 5,
          "url": "https://www.morenews.org/politics/watchdog-discovered-serious-shortcomings-in-vetting-and-misconduct-checks"
        },
        {
          "@type": "ListItem",
          "position": 6,
          "url": "https://www.morenews.org/politics/labour-struggles-gorton-by-election-burnham-starmer"
        }
      ]
    }

  ]
}
</script>

</head>


<body>
    <!-- header -->
<?php include '../header.php'; ?>

    <div class="main-container">
        <main>
        <section class="headline-rail">
            

        </section>
        <!-- HTML -->
        <section class="bio-panel">
            <div class="bio-container">
                <div class="bio-photo">
                    <img src="../images/emily-hargreaves.webp"
                        alt="Emily Hargreaves">
                </div>
                
                <div class="bio-details">
                    <h1 class="bio-name">Emily Hargreaves</h1>
                    <p class="bio-text">
                        Emily Hargreaves is a political journalist covering UK politics, policy, and government affairs. She focuses on clear, balanced reporting and in-depth analysis of developments shaping Westminster and public life.
                    </p>
                </div>
                <div class="share-icons">
                    <a href="https://www.quora.com/profile/Emily-Hargreaves-37" title="quora" class="share-btn"><i class="fa-brands fa-quora" style="color: #000000;"></i></i></a>
                    <a href="https://flipboard.com/@emilyhargre" title="flipboard" class="share-btn"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a>
                    <a href="https://medium.com/@emilyhargreaves_1317" title="medium" class="share-btn"><img src="../images/medium.webp" alt="medium" height="20px" width="20px"></i></i></a>
                    <a href="https://substack.com/@emilyhargreaves?" title="substack" class="share-btn"><img src="../images/substack.webp" alt="substack" height="20px" width="20px"></a>
                </div>
            </div>
        </section>

<h2 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;"> Emily Hargreaves is a political journalist</h2>
<h3 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">political,politics</h3>     



        <!-- Content + Sidebar -->
        <div class="news-flexzone">

            <!-- News List -->
            <div class="news-listcol">

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials.php" title="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials">David Lammy is anticipated to modify his plans to eliminate the majority of jury trials</a>
                        <p>After getting "cabinet feedback," the justice secretary says he will stick to Leveson's suggested three-year sentence level.</p>
                    </div>
                    <div class="news-imgpart">
                        <img src="../images/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials-first-image.webp" alt="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials first image">
                    </div>
                </div>

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early.php"
                             title="The OBR chair quits after an investigation into how the budget draft was sent out early">The OBR chair quits after an investigation into how the budget draft was sent out early</a>
                        <p>Richard Hughes takes "full responsibility" for the watchdog mistake while Starmer tries to get the job of chancellor.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early-first-iamge.webp" 
                        alt="The OBR chair quits after an investigation into how the budget draft was sent out early first image">
                    </div>
                </div>

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php" title="Angela Rayner will propose a change to expedite the workers' rights bill">Angela Rayner will propose a change to expedite the workers' rights bill</a>
                        <p>Angela Rayner has confirmed that Labour’s upcoming workers’ rights bill will introduce day-one protections against unfair treatment, as part of plans to modernise employment law and strengthen job security.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-first-image.webp"
                         alt="Angela Rayner stressed Labour's commitment to workers' rights from the start during major employment changes first image">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php" title="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax" >Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax</a>
                        <p>The UK will put a carbon border tax in place by 2027. This will make things that emit a lot of carbon, like cement and steel, more expensive. Businesses say it could raise costs and cause problems in the supply chain.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/despite-business-concerns-the-uk-will-move-forward-first-image.webp"
                         alt="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax first image">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../politics/watchdog-discovered-serious-shortcomings-in-vetting-and-misconduct-checks.php" title="watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny" >
                                    watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny</a>
                        <p>A watchdog says that the Metropolitan Police may have hired thousands of police officers without doing enough background checks. This raises new questions about the police's policies for screening and misconduct.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/watchdog-discovered-serious-shortcomings-in-vetting-and-misconduct-checks-first-image.webp" 
                        alt="watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny first image">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../politics/labour-struggles-gorton-by-election-burnham-starmer.php" title="Burnham’s Potential Return to Parliament Sparks Labour Party Divisions" >
                                    Burnham’s Potential Return to Parliament Sparks Labour Party Divisions</a>
                        <p>Keir Starmer’s allies launch a campaign to block Burnham’s return to Parliament amid Gorton by-election tensions. Will Burnham challenge Starmer’s leadership?
                        </p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/labour-struggles-gorton-by-election-burnham-starmer.webp" 
                        alt="Burnham’s Potential Return to Parliament Sparks Labour Party Divisions">
                    </div>
                </div>
                
            </div>

            <!-- Sidebar -->
            <div class="side-railbox">
                <div class="side-adunit">
                    <!-- <div class="sponsor-note">- A Word From Our Sponsors -</div> -->
                    <a href="https://www.venture-hive.com/" title="venture hive"><img loading="lazy" src="../images/venture-hive.webp"
                        alt="venture-hive"></a>
                </div>
                <div class="side-socialpanel">
                    <h4>Follow Us</h4>
                    <ul>
                        <li><a href="https://x.com/More_NewsMN" title="Twitter"><i class="fa-brands fa-x-twitter" style="color: #000000;"></i></a></li>
                        <li><a href="https://www.instagram.com/morewnews_/" title="instagram"><img src="../images/instagram.webp" alt="instagram" height="20px" width="20px"></a></li>
                       
                        <li><a href="https://www.quora.com/profile/More-News-6" title="Quora"><i class="fa-brands fa-quora" style="color: #000000;"></i></a></li>
                        <li><a href="https://flipboard.com/@more_news" title="Flipboard"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a></li>
                        <li><a href="https://medium.com/@more_news" title="Medium"><img src="../images/medium.webp" alt="Medium" height="20px" width="20px"></a></li>
                        <li><a href="https://substack.com/@morenewsmn" title="Substack"><img src="../images/substack.webp" alt="Substack" height="19px" width="19px"></a></li>
                    </ul>

                </div>
            </div>

        </div>
        </main>
        <!-- footer -->
<?php include '../footer.php'; ?>
    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>