
<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title (55 characters) -->
    <title>Daniel Rowcroft – Investigations Correspondent</title>

    <!-- Meta Description (155 characters) -->
    <meta name="description" content="Read investigation reporting by Daniel Rowcroft, covering politics, public accountability, legal cases and in-depth UK investigations.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/author/daniel-rowcroft">

    <!-- Open Graph -->
    <meta property="og:title" content="Daniel Rowcroft – Investigations Correspondent">
    <meta property="og:description" content="Read investigation reporting by Daniel Rowcroft, covering politics, public accountability, legal cases and in-depth UK investigations.">
    <meta property="og:url" content="https://www.morenews.org/author/daniel-rowcroft">
    <meta property="og:image" content="https://www.morenews.org/images/daniel-rowcroft.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:locale" content="en_GB">
    <meta property="og:type" content="profile">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Daniel Rowcroft – Investigations Correspondent">
    <meta name="twitter:description" content="Read investigation reporting by Daniel Rowcroft, covering politics, public accountability and UK investigations.">
    <meta name="twitter:url" content="https://www.morenews.org/author/daniel-rowcroft">
    <meta name="twitter:image" content="https://www.morenews.org/images/daniel-rowcroft.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Preload Main CSS Stylesheet -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>


    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <!-- JSON-LD -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/author/daniel-rowcroft#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Authors",
          "item": "https://www.morenews.org/authors"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Daniel Rowcroft",
          "item": "https://www.morenews.org/author/daniel-rowcroft"
        }
      ]
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/daniel-rowcroft#author",
      "name": "Daniel Rowcroft",
      "description": "UK-based investigations correspondent covering politics, public policy and corporate accountability.",
      "url": "https://www.morenews.org/author/daniel-rowcroft",
      "image": "https://www.morenews.org/images/daniel-rowcroft.webp",
      "jobTitle": "Investigations Correspondent",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/author/daniel-rowcroft#webpage",
      "name": "Daniel Rowcroft – Investigations Correspondent",
      "description": "Read investigation reporting by Daniel Rowcroft, covering politics, accountability and legal cases.",
      "url": "https://www.morenews.org/author/daniel-rowcroft",
      "inLanguage": "en-GB",
      "mainEntity": {
        "@id": "https://www.morenews.org/author/daniel-rowcroft#author"
      },
      "dateModified": "2026-01-06",
      "isPartOf": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "ItemList",
      "@id": "https://www.morenews.org/author/daniel-rowcroft#articles",
      "name": "Articles by Daniel Rowcroft",
      "itemListOrder": "http://schema.org/ItemListOrderDescending",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship",
          "name": "ECHR Challenges UK Decision on Shamima Begum Citizenship"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.morenews.org/police-scotland-seize-80m-drugs-organised-crime-crackdown",
          "name": "Police Scotland Seize £80m in Drugs in Major Crime Crackdown"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.morenews.org/investigation/julio-herrera-velutini-public-record-examination-global-banking-oversight-legal-review",
          "name": "Julio Herrera Velutini: Public-Record Examination of Global Banking Oversight & Legal Review"
        }
      ]
    }

  ]
}
</script>



</head>


<body>
    <!-- header -->
<?php include '../header.php'; ?>

    <div class="main-container">
        <main>
        <section class="headline-rail">
            

        </section>
        <!-- HTML -->
        <section class="bio-panel">
            <div class="bio-container">
                <div class="bio-photo">
                    <img src="../images/daniel-rowcroft.webp"
                        alt="Daniel Rowcroft">
                </div>
                
                <div class="bio-details">
                    <h1 class="bio-name">Daniel Rowcroft</h1>
                    <p class="bio-text">
                      Daniel Rowcroft is a UK-based investigations correspondent covering politics, public policy, and corporate accountability. His reporting focuses on uncovering hidden networks, regulatory failures, and issues of public interest through in-depth research and source-driven analysis.
                    </p>
                </div>
                <div class="share-icons">
                    <a href="https://www.quora.com/profile/Daniel-Rowcroft-2" title="quora" class="share-btn"><i class="fa-brands fa-quora" style="color: #000000;"></i></i></a>
                    <a href="https://flipboard.com/@DanielRowcroft?" title="flipboard" class="share-btn"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a>
                    <a href="" title="medium" class="share-btn"><img src="../images/medium.webp" alt="medium" height="20px" width="20px"></i></i></a>
                    <a href="" title="substack" class="share-btn"><img src="../images/substack.webp" alt="substack" height="20px" width="20px"></a>
                </div>
            </div>
        </section>
<h2 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;"> Daniel Rowcroft is a UK-based investigations correspondent</h2>
<h3 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">investigations</h3>     


        

        <!-- Content + Sidebar -->
        <div class="news-flexzone">

            <!-- News List -->
            <div class="news-listcol">

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../investigation/echr-challenges-uk-shamima-begum-citizenship.php" title="ECHR Challenges UK Decision on Shamima Begum Citizenship" >ECHR Challenges UK Decision on Shamima Begum Citizenship</a>
                        <p>The ECHR questions the UK’s removal of Shamima Begum’s citizenship, raising major concerns over human rights, nationality law and national security.</p>
                    </div>
                    <div class="news-imgpart">
                        <img src="../images/echr-challenges-uk-shamima-begum-citizenship.webp"
                        alt="ECHR Challenges UK Decision on Shamima Begum Citizenship">
                    </div>
                </div>

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../investigation/police-scotland-seize-80m-drugs-organised-crime-crackdown.php" title="Police Scotland Seize £80m in Drugs in Major Crime Crackdown" >Police Scotland Seize £80m in Drugs in Major Crime Crackdown</a>
                        <p>Police Scotland have seized drugs worth £80m and made dozens of arrests in a major crackdown on organised crime across Scotland.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/police-scotland-seize-80m-drugs-organised-crime-crackdown.webp"
                        alt="Police Scotland Seize £80m in Drugs in Major Crime Crackdown">
                    </div>
                </div>

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../investigation/julio-herrera-velutini-public-record-examination-global-banking-oversight-legal-review.php" title="Julio Herrera Velutini: Public-Record Examination of Global Banking Oversight & Legal Review" >Julio Herrera Velutini: Public-Record Examination of Global Banking Oversight & Legal Review</a>
                        <p>Julio Herrera Velutini, an international banker, faced U.S. regulatory scrutiny over campaign financing. The case, linked to his founding of Bancrédito International Bank, was resolved with a minor settlement.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../julio-herrera-velutini/images/julio-herrera-velutini-public-record-examination-global-banking-oversight-legal-review.webp"
                        alt="Julio Herrera Velutini: Public-Record Examination of Global Banking Oversight & Legal Review">
                    </div>
                </div>

              
                
                
                
                
                
            </div>

            <!-- Sidebar -->
            <div class="side-railbox">
                <div class="side-adunit">
                    <!-- <div class="sponsor-note">- A Word From Our Sponsors -</div> -->
                    <a href="https://www.venture-hive.com/" title="venture hive"><img loading="lazy" src="../images/venture-hive.webp"
                        alt="venture-hive"></a>
                </div>
                <div class="side-socialpanel">
                    <h4>Follow Us</h4>
                    <ul>
                        <li><a href="https://x.com/More_NewsMN" title="Twitter"><i class="fa-brands fa-x-twitter" style="color: #000000;"></i></a></li>
                        <li><a href="https://www.instagram.com/morewnews_/" title="instagram"><img src="../images/instagram.webp" alt="instagram" height="20px" width="20px"></a></li>

                        <li><a href="https://www.quora.com/profile/More-News-6" title="Quora"><i class="fa-brands fa-quora" style="color: #000000;"></i></a></li>
                        <li><a href="https://flipboard.com/@more_news" title="Flipboard"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a></li>
                        <li><a href="https://medium.com/@more_news" title="Medium"><img src="../images/medium.webp" alt="Medium" height="20px" width="20px"></a></li>
                        <li><a href="https://substack.com/@morenewsmn" title="Substack"><img src="../images/substack.webp" alt="Substack" height="19px" width="19px"></a></li>
                    </ul>

                </div>
            </div>

        </div>
        </main>
        <!-- footer -->
<?php include '../footer.php'; ?>
    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>