
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title (55 characters exact) -->
    <title>Callum Fraser – Sports Journalist at More News</title>

    <!-- Meta Description (155 characters exact) -->
    <meta name="description" content="Read the latest sports coverage by Callum Fraser, reporting on football, major tournaments, grassroots sport and UK athletics at More News.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/author/callum-fraser">

    <!-- Open Graph -->
    <meta property="og:title" content="Callum Fraser – Sports Journalist at More News">
    <meta property="og:description" content="Read the latest sports coverage by Callum Fraser, reporting on football, major tournaments, grassroots sport and UK athletics at More News.">
    <meta property="og:url" content="https://www.morenews.org/author/callum-fraser">
    <meta property="og:image" content="https://www.morenews.org/images/callum-fraser.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:locale" content="en_GB">
    <meta property="og:type" content="profile">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Callum Fraser – Sports Journalist at More News">
    <meta name="twitter:description" content="Read the latest sports coverage by Callum Fraser, reporting on football, major tournaments, grassroots sport and UK athletics at More News.">
    <meta name="twitter:url" content="https://www.morenews.org/author/callum-fraser">
    <meta name="twitter:image" content="https://www.morenews.org/images/callum-fraser.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Preload Main CSS Stylesheet -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>


    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/author/callum-fraser#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Authors",
          "item": "https://www.morenews.org/authors"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Callum Fraser",
          "item": "https://www.morenews.org/author/callum-fraser"
        }
      ]
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/callum-fraser#author",
      "name": "Callum Fraser",
      "description": "Sports journalist covering football, major tournaments and grassroots sport across the UK.",
      "url": "https://www.morenews.org/author/callum-fraser",
      "image": "https://www.morenews.org/images/callum-fraser.webp",
      "jobTitle": "Sports Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/author/callum-fraser#webpage",
      "name": "Callum Fraser – Sports Journalist at More News",
      "description": "Read the latest sports coverage by Callum Fraser, reporting on football, major tournaments, grassroots sport and UK athletics at More News.",
      "url": "https://www.morenews.org/author/callum-fraser",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "mainEntity": {
        "@id": "https://www.morenews.org/author/callum-fraser#author"
      },
      "dateModified": "2025-12-12"
    },

    {
      "@type": "ItemList",
      "@id": "https://www.morenews.org/author/callum-fraser#articles",
      "name": "Articles by Callum Fraser",
      "itemListOrder": "Descending",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.morenews.org/sports/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season-ends"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.morenews.org/sports/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling-prepares"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa"
        },
        {
          "@type": "ListItem",
          "position": 4,
          "url": "https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace"
        }
      ]
    }

  ]
}
</script>


</head>


<body>
    <!-- header -->
<?php include '../header.php'; ?>

    <div class="main-container">
      <main>
        
        <section class="headline-rail">
            

        </section>
        <!-- HTML -->
        <section class="bio-panel">
            <div class="bio-container">
                <div class="bio-photo">
                    <img src="../images/callum-fraser.webp"
                        alt="Callum Fraser">
                </div>
                
                <div class="bio-details">
                    <h1 class="bio-name">Callum Fraser</h1>
                    <p class="bio-text">
                        Callum Fraser is a sports journalist who writes about football, big competitions, and grassroots sports. He focuses on the stories that affect sports in the UK.
                    </p>
                </div>
                <div class="share-icons">
                    <a href="https://www.quora.com/profile/Callum-Fraser-66" title="quora" class="share-btn"><i class="fa-brands fa-quora" style="color: #000000;"></i></i></a>
                    <a href="https://flipboard.com/@CallumFrase" title="flipboard" class="share-btn"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a>
                    <a href="https://medium.com/@callumfraser_78280" title="medium" class="share-btn"><img src="../images/medium.webp" alt="medium" height="20px" width="20px"></i></i></a>
                    <a href="https://substack.com/@callumfraser67" title="substack" class="share-btn"><img src="../images/substack.webp" alt="substack" height="20px" width="20px"></a>
                </div>
            </div>
        </section>
<h2 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">callun fraser sports journalist</h2>
<h3 style="position: absolute; width: 1px; height: 1px; margin: -1px; padding: 0; border: 0; overflow: hidden;">sports</h3>     

        <!-- Content + Sidebar -->
        <div class="news-flexzone">

            <!-- News List -->
            <div class="news-listcol">

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../sports/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season.php" title="British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close" >British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close</a>
                        <p>Britain’s Formula 1 drivers came together at the FIA Prize Giving ceremony to reflect on a demanding season, marking its close while already looking ahead to the challenges of the next campaign.</p>
                    </div>
                    <div class="news-imgpart">
                        <img src="../images/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season-first-image.webp"
                        alt="British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close first image">
                    </div>
                </div>

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../sports/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling.php" title="Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets" >Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets</a>
                        <p>Team GB’s cyclists are beginning preparations for the 2026 season after British Cycling set new performance targets, with a renewed focus on youth development, endurance events and long-term success.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling-first-image.webp"
                        alt="Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets first image">
                    </div>
                </div>

                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../sports/fa-to-raise-world-cup-ticket-concerns-with-fifa.php" title="FA to raise World Cup ticket concerns with FIFA" class="title-link">FA to raise World Cup ticket concerns with FIFA</a>
                        <p>The FA is set to raise concerns with FIFA over the cost of tickets for the 2026 World Cup, amid fears that rising prices could price many England supporters out of the tournament.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/fa-to-raise-world-cup-ticket-concerns-with-fifa-first-image.webp"
                            alt="FA to raise World Cup ticket concerns with FIFA first image">
                    </div>
                </div>
                <div class="news-blockitem">
                    <div class="news-textpart">
                        <a href="../sports/world-darts-championship-under-way-at-alexandra-palace.php" title="World Darts Championship Under Way at Alexandra Palace" class="title-link">World Darts Championship Under Way at Alexandra Palace</a>
                        <p>The World Darts Championship is back at Alexandra Palace, with a larger field, packed crowds and reigning champion Luke Littler among the favourites as the tournament gets under way.</p>
                    </div>
                    <div class="news-imgpart">
                        <img loading="lazy" src="../images/world-darts-championship-under-way-at-alexandra-palace-first-image.webp"
                            alt="World Darts Championship Under Way at Alexandra Palace first image">
                    </div>
                </div>
                
                
                
                
                
            </div>

            <!-- Sidebar -->
            <div class="side-railbox">
                <div class="side-adunit">
                    <!-- <div class="sponsor-note">- A Word From Our Sponsors -</div> -->
                    <a href="https://www.venture-hive.com/" title="venture hive"><img loading="lazy" src="../images/venture-hive.webp"
                        alt="venture-hive"></a>
                </div>
                <div class="side-socialpanel">
                    <h4>Follow Us</h4>
                    <ul>
                        <li><a href="https://x.com/More_NewsMN" title="Twitter"><i class="fa-brands fa-x-twitter" style="color: #000000;"></i></a></li>
                        <li><a href="https://www.instagram.com/morewnews_/" title="instagram"><img src="../images/instagram.webp" alt="instagram" height="20px" width="20px"></a></li>
                        <li><a href="https://www.quora.com/profile/More-News-6" title="Quora"><i class="fa-brands fa-quora" style="color: #000000;"></i></a></li>
                        <li><a href="https://flipboard.com/@more_news" title="Flipboard"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a></li>
                        <li><a href="https://medium.com/@more_news" title="Medium"><img src="../images/medium.webp" alt="Medium" height="20px" width="20px"></a></li>
                        <li><a href="https://substack.com/@morenewsmn" title="Substack"><img src="../images/substack.webp" alt="Substack" height="19px" width="19px"></a></li>
                    </ul>


                </div>
            </div>

        </div>
</main>
        <!-- footer -->
<?php include '../footer.php'; ?>
    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>

    <!-- <script src="js/style.js" defer></script> -->
</body>

</html>