<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO -->
    <title>About More News | Independent Global Journalism Platform</title>
    <meta name="title" content="About More News | Independent Global Journalism Platform">
    <meta name="description"
        content="Learn more about More News, an independent digital journalism platform delivering trusted reporting, analysis and in-depth coverage of global and UK affairs.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/about">

    <!-- Open Graph -->
    <meta property="og:title" content="About More News | Independent Global Journalism Platform">
    <meta property="og:description"
        content="Learn more about More News, an independent digital journalism platform delivering trusted reporting, analysis and in-depth coverage of global and UK affairs.">
    <meta property="og:url" content="https://www.morenews.org/about">
    <meta property="og:image" content="https://www.morenews.org/images/morenews-about.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="About More News | Independent Global Journalism Platform">
    <meta name="twitter:description"
        content="Learn more about More News, an independent digital journalism platform delivering trusted reporting, analysis and in-depth coverage of global and UK affairs.">
    <meta name="twitter:url" content="https://www.morenews.org/about">
    <meta name="twitter:image" content="https://www.morenews.org/images/morenews-about.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="css/style.css" as="style">
    <link rel="stylesheet" href="css/style.css">

        <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">

    <!-- Schema -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News",
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/about#webpage",
      "url": "https://www.morenews.org/about",
      "name": "About More News | Independent Global Journalism Platform",
      "description": "Learn more about More News, an independent digital journalism platform delivering trusted reporting, analysis and in-depth coverage of global and UK affairs.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/morenews-about.webp",
        "width": 1200,
        "height": 630
      }
    }

  ]
}
</script>

</head>


<body>

  <!-- Header -->
  <?php include 'index-header.php'; ?>

  <div class="main-container">
    <section class="headline-rail">

        </section>

    <!-- MAIN CONTENT -->
    <div class="story-wrapper">
      <div class="story-grid">

        <!-- LEFT CONTENT -->
        <div class="primary-feed">

          <!-- HERO IMAGE -->
          

          <!-- ARTICLE HEADER -->
          <div class="article-header">
            <div class="article-breadcrumb">
              <a href="index.php" title="home" class="crumb-link">Home</a> /
              <span class="crumb-current">About</span>
            </div>

            <h1 class="article-headline">About More News</h1>
          </div>
          <div class="image-wrapper">
            <img src="images/morenews-about.webp" alt="More News About">
          </div>

          <!-- ARTICLE CONTENT -->
          <div class="writer-block">
            <div class="story-text-wrap">

              <p>
                <strong>More News</strong> is an independent digital news platform committed to
                delivering accurate, thoughtful, and in-depth journalism on the issues shaping our world.
                We cover UK politics, global affairs, economics, climate, science, and social change with
                clarity and integrity.
              </p>

              <p>
                Founded on the principles of transparency and public accountability, More News
                aims to cut through noise and misinformation by focusing on verified reporting,
                contextual analysis, and human-centered storytelling.
              </p>

              <p>
                Our newsroom brings together journalists, analysts, and editors who believe journalism
                should inform, challenge power, and empower readers with facts—not outrage.
              </p>

              <p>
                We are not driven by political parties or corporate interests. Our mission is simple:
                to publish journalism that helps readers understand what is happening, why it matters,
                and how it affects their lives.
              </p>

              <p>
                More News is reader-focused, globally aware, and dedicated to upholding
                the highest standards of modern journalism.
              </p>

            </div>
          </div>

        </div>

        <!-- SIDEBAR -->
        <div class="side-railbox">
            <br>
          <div class="side-adunit">
            <a href="https://www.venture-hive.com/" title="venture hive"><img src="images/venture-hive.webp"
                        alt="venture-hive"></a>
          </div>
 
          <div class="side-socialpanel">
            <h4>Follow Us</h4>
            <ul>
                        <a href="https://x.com/More_NewsMN" alt="twitter"><i class="fa-brands fa-x-twitter" style="color: #000000;"></i></a>
                    <a href="https://www.instagram.com/morewnews_/" title="instagram"><img src="images/instagram.webp" alt="instagram" height="20px" width="20px"></a>
                        
                        <a href="https://www.quora.com/profile/More-News-6" alt="quora"><i class="fa-brands fa-quora" style="color: #000000;"></i></i></a>
                        <a href="https://flipboard.com/@more_news" alt="flipboard"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a>
                        <a href="https://medium.com/@more_news" alt="medium"><img src="images/medium.webp" alt="medium" height="20px" width="20px"></i></i></a>
                        <a href="https://substack.com/@morenewsmn" alt="substack"><img src="images/substack.webp" alt="substack" height="19px" width="19px"></a>
                    </ul>
          </div>

        </div>

      </div>
    </div>
    <?php include 'index-footer.php'; ?>

  </div>

  <!-- Footer -->
  

  <!-- Scroll to top -->
  <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
  </button>

  <script src="js/style.js"></script>

</body>
</html>
