<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>U.S. Executive Orders Signal Sharp Shift in Environment and Trade Policy</title>
    <link rel="stylesheet" href="../style.css">
</head>
<body>

  <!-- header -->
  <?php include ('../header.php'); ?>



    <main>
<!-- sixth section -->
 <div class="featured-container expose">


  <div class="featured-grid">
    <!-- Left Large Video -->
    <div class="featured-left">
         <div class="post-wrapper">
    <div class="post-inner">

      <div class="post-tag">U.S News</div>

      <h1 class="post-heading">U.S. Executive Orders Signal Sharp Shift in Environment and Trade Policy</h1>

      <div class="post-description">
    Recent White House actions highlight a tougher stance on China, minerals, and emissions regulation as policymakers reevaluate U.S. economic dependencies.
  </div>

      <div class="post-info">
        <div class="post-author">BY <span>JORDAN LEE</span></div>
        <div class="post-date">NOVEMBER 1, 2025</div>
      </div>

      <!-- social content -->
       <?php include ('../social-content.php'); ?>
      
  </div>

   <div class="">
       <img loading="lazy" src="../images/u-s-executive-orders-signal-sharp-shift.webp" alt="u-s-and-china-sign-big-trade-deal" class="featured-main-img">

      <p class="trend-text sety "  >
   The White House put out a number of executive actions this week that focus on strategic minerals, carbon regulations, and making the U.S. economy more competitive with China. This shows a big shift in U.S. trade and regulatory priorities.   The orders come after years of bipartisan calls to make American supply chains stronger and less reliant on Chinese production, especially in the renewable energy sector.
  </p>
        <p class="trend-text sety" >
    Even though no new trade deal has been reached, senior officials in the U.S. government said that the country is looking into a number of Section 301 tariff measures that affect solar equipment, important minerals, and parts for electric vehicles.   The study is being done because the U.S. Trade Representative promised to look into whether current tariffs are still "appropriate and effective" in a global market where China is the most powerful industrial country.
  </p>
         <p class="trend-text sety" >
   U.S. regulators have been keeping a closer eye on Chinese investments, raised the limits on exports of advanced semiconductors, and looked more closely at supply chains in industries that are important for energy resilience and the military.   Analysts say that the executive orders do not show a shift toward cooperation, but rather support a larger U.S. strategy.
  </p>
  <div class="quates">
        <p>“We want to protect national security while helping American businesses as the US enters a new era of strategic economic competition."</p>
      </div>
     <p class="trend-text sety" >
     Trade groups were happy that trade rules were made clearer, but they warned that producers are still unsure because tariff policies can change at any time.   American importers of batteries, electronics, and solar components say that long-term planning has become harder as export rules and tariff evaluations change.
</p>
    <p class="trend-text sety" >
     China, on the other hand, says that the U.S. limits on high-tech exports break international trade rules.   Trade experts say that there isn't much evidence of serious negotiations going on, and both countries are still having a hard time with their economies.
    </p>

    

     <img loading="lazy" src="../images/congress-is-putting-pressure-on-the-white-house.webp" alt="Congress is putting pressure on the White House" class="featured-main-img">

     <h2 class="post-heading">Congress is putting pressure on the White House to be tougher on Chinese imports.</h2>
     <p class="trend-text sety loco">
        Members of both parties have told the White House to rely less on Chinese rare-earth processing and make more important minerals at home.   Lawmakers say that the US still relies heavily on China for the minerals needed for wind turbines, batteries, electric cars, and technology that keeps the country safe.  Since 2021, a number of congressional evaluations of the supply chain have shown this weakness.
      </p>
        <p class="trend-text sety">
        Senators from mining states like Nevada, Alaska, and Arizona have been putting pressure on the administration to speed up the approval process for lithium, graphite, and cobalt projects.  In the meantime, lawmakers in the Midwest say that US automakers won't be able to meet federal clean energy goals unless the US builds a complete supply chain from mining to manufacturing that doesn't rely on Chinese processing.
      </p>
         <p class="trend-text sety">
        The Inflation Reduction Act (IRA) says that subsidized electric vehicles can't have parts made in China. A bipartisan group of senators asked the federal government to strictly follow these new rules.  Under the new rules, cars that have important minerals or battery parts from "foreign entities of concern," like China, are no longer eligible for some tax breaks.  Automakers' quick changes to their supply chains may slow down the adoption of electric vehicles, but lawmakers say that giving exemptions would hurt national security goals.
      </p>
         
     
        <div class="footerArea_x91">
    
    <!-- TAGS SECTION -->
    <div class="tagSection_x91">
      <div class="tagLabel_x91">Tags:</div>
      <div class="tagButtons_x91">
        <a href="#">Elegant</a>
        <a href="#">Fashion</a>
        <a href="#">Trendy</a>
      </div>
    </div>

    <!-- AUTHOR SECTION -->
    <?php include ('../authors/us-author.php'); ?>

    <!-- COMMENT SECTION -->
    <?php include ('../comment.php'); ?>

  </div>

   </div>

    </div>

    <!-- Right Smaller Videos -->
    <?php include ('../side-content.php'); ?>

<!-- trending news section -->
<div class="trend-wrapper">
  <h3 class="trend-heading">U.S News</h3>

  <div class="trend-grid">

    <!-- Post 1 -->
    <div class="trend-card">
      <img loading="lazy" src="../images/trump-criticizes-mamdani-and-signals-support-for-cuomo-1.webp" width="140" height="110" alt="Trump Criticizes Mamdani and Signals Support for Cuomo in Heated NYC Mayoral Race" class="trend-image">
      <h2 class="trend-title">
        <a href="../usnews/trump-criticizes-mamdani-and-signals-support-for-cuomo.php">Trump Criticizes Mamdani and Signals Support for Cuomo in Heated NYC Mayoral Race</a>
      </h2>
      <p class="trend-text">
       Trump backs Cuomo and says that if Mamdani wins, he will stop giving money to the federal government. Mamdani calls the threat a tool of politics. Experts say that Trump's involvement could make things worse and make it harder for New Yorkers to get the help they need.
      </p>
      <p class="trend-info">
       <span class="trend-cat">U.S News</span> BY <span class="trend-author">JORDAN LEE</span> NOVEMBER 4, 2025
      </p>
    </div>

    <!-- Post 1 -->
    <div class="trend-card">
      <img loading="lazy" src="../images/the-u-s-government-has-been-closed-for-the-longest-time.webp" width="140" height="110" alt="The U.S. government has been closed for the longest time" class="trend-image">
      <h2 class="trend-title">
        <a href="../usnews/the-u-s-government-has-been-closed-for-the-longest-time.php">The U.S. government has been closed for the longest time.</a>
      </h2>
      <p class="trend-text">
        The federal government has been shut down for 36 days, which is a new record, because the US Senate has once again failed to pass any laws.</p>
      <p class="trend-info">
        <span class="trend-cat">U.S News</span> BY <span class="trend-author">JORDAN LEE</span> NOVEMBER 4, 2025
      </p>
    </div>

    <!-- Post 2 -->
    <div class="trend-card">
      <img loading="lazy" src="../images/a-big-winter-storm-hits-the-northeastern-u.s.webp" width="140" height="110" alt="A big winter storm hits the Northeastern U.S" class="trend-image">
      <h2 class="trend-title">
        <a href="../usnews/a-big-winter-storm-hits-the-northeastern-u.s.php">The U.S. government has been closed for the longest time.</a>
      </h2>
      <p class="trend-text">
      In the Northeast, a strong snowstorm made conditions like a blizzard, which made travel difficult and forced schools to close in several states.
      <p class="trend-info">
        <span class="trend-cat">U.S News</span> BY <span class="trend-author">JORDAN LEE</span> OCTOBER 11, 2025
      </p>
    </div>

  </div>
</div>




    </main>

  <!-- footer -->
  <?php include ('../footer.php'); ?>

  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>

</body>
</html>