<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=UnifrakturMaguntia&display=swap" rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&family=Noto+Serif+JP:wght@200..900&display=swap"
        rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
        integrity="sha512-DxV+EoADOkOygM4IR9yXP8Sb2qwgidEmeqAEmDKIOfPRQZOWbXCzLC6vjbZyy0vPisbH2SyW27+ddLVCN+OMzQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- SEO -->
    <title>IOC Backs Return of Russian and Belarusian Youth Athletes</title>
    <meta name="title" content="IOC Backs Return of Russian and Belarusian Youth Athletes">
    <meta name="description"
        content="The IOC says young athletes from Russia and Belarus should be allowed to compete internationally under their national flags, arguing minors should not face political punishment.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/world/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate.php">

    <!-- Open Graph -->
    <meta property="og:title" content="IOC Backs Return of Russian and Belarusian Youth Athletes">
    <meta property="og:description"
        content="The IOC says young athletes from Russia and Belarus should be allowed to compete internationally under their national flags, arguing minors should not face political punishment.">
    <meta property="og:url" content="https://www.morenews.org/world/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate.php">
    <meta property="og:image" content="https://www.morenews.org/images/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="IOC Backs Return of Russian and Belarusian Youth Athletes">
    <meta name="twitter:description"
        content="The IOC says young athletes from Russia and Belarus should be allowed to compete internationally under their national flags, arguing minors should not face political punishment.">
    <meta name="twitter:url" content="https://www.morenews.org/world/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate.php">
    <meta name="twitter:image" content="https://www.morenews.org/images/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate-first-image.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Favicon -->
    <link rel="icon" href="../images/icon.svg">

    <!-- Schema -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/sophie-caldwell.php#author",
      "name": "Sophie Caldwell",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/world/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "World",
          "item": "https://www.morenews.org/world/world.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "IOC Backs Return of Russian and Belarusian Youth Athletes",
          "item": "https://www.morenews.org/world/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate.php"
        }
      ]
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/world/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate.php#article",
      "headline": "IOC Backs Return of Russian and Belarusian Youth Athletes",
      "description": "The IOC says young athletes from Russia and Belarus should be allowed to compete internationally under their national flags, arguing minors should not face political punishment.",
      "datePublished": "2025-12-12",
      "dateModified": "2025-12-12",
      "articleSection": "World",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/sophie-caldwell.php#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/world/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate.php"
      }
    }

  ]
}
</script>

</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
                IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate
            </h1>

            <div class="article-breadcrumb">
                <a href="../world/world.php" class="crumb-link">World</a> ›
                <span class="crumb-current">IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate</span>
            </div>

            <div class="share-icons">
                <a href="#" class="share-btn"><i class="fab fa-facebook-f"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-x-twitter"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-pinterest-p"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-whatsapp"></i></a>
            </div>
        </div>
        <div class="image-wrapper">
            <img src="../images/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate-first-image.webp" alt="IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate first image">
        </div>
        <div class="writer-block">
            <!-- author -->
<?php include '../world-author.php'; ?>


            <div class="story-text-wrap">
                <h2 class="writer-date">12 December 2025</h2>
                <p>
                    The International Olympic Committee (IOC) has put out new rules saying that young athletes from Belarus and Russia should be able to compete around the world under their own flags and anthems.  This is a big change in policy that could completely change how sports are governed around the world.   AP News says that this is part of a larger conversation about how international sports groups should deal with young athletes from countries that are going through political turmoil.
                </p>

                <p>
                    The recommendation is aimed specifically at youth-level events, where the IOC argues the priority must be protecting the welfare and future prospects of young athletes. According to officials, minors should not face “collective punishment” for political decisions made by their governments or military leadership. The committee stressed that while governments may be in conflict, children engaged in sport should remain shielded from geopolitical retaliation wherever possible.
                </p>

                
                <p>
                This marks a notable softening compared with the stricter limitations placed on senior Russian and Belarusian athletes following Russia’s invasion of Ukraine in 2022. Senior competitors remain barred from representing their nations at major events, including the upcoming 2026 Winter Olympics, where those cleared to participate may only do so as neutral athletes without flags, anthems or national symbols. By contrast, under the new guidance, youth athletes would be permitted to compete fully under their national identity.
                </p>
                <p>
               The IOC emphasised that the recommendation applies only to athletes — not to government officials, political delegates, or individuals holding positions within the Russian or Belarusian administrations. Sports bodies were reminded that political figures should continue to be excluded from all international competitions and ceremonies under existing sanctions.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img src="../images/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate-second-image.webp" alt="IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
                   Officials also stressed that safety, fairness, and the integrity of the competition are still very important.   Young athletes would still have to meet strict eligibility requirements and go through extra screening to make sure they are not linked to military groups or propaganda campaigns.   The IOC said that sports federations still have the final say over who can participate because the process of reintegration does not replace evaluations on a case-by-case basis.
                </p>

                <p>
                   People in the sports world around the world have reacted in different ways.   Several federations have cautiously welcomed the change, saying it supports the idea that sports should continue to be a way for young people to grow and bring about peace.   Some people are worried that it could cause problems or let politicians take advantage of a sensitive time.
                </p>
                <p>
                   The IOC, on the other hand, says that keeping young athletes out of political conflict is necessary to protect the values of international sport.   As international federations start to look at the rules, the ruling is likely to lead to more debate about how sports should deal with the world's increasingly unstable political climate.</p>
            </div>

        </div>
        
        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">World</h3>

                <div class="suggested-item">
                    <img src="../images/a-big-international-interpol-operation-saves-almost-30000-animals-first-image.webp"
                            alt="A big international Interpol operation saves almost 30,000 animals that were trafficked" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../world/a-big-international-interpol-operation-saves-almost-30000-animals.php"
                         title="A big international Interpol operation saves almost 30,000 animals that were trafficked." class="suggested-title">A big international Interpol operation saves almost 30,000 animals that were trafficked</a>
                        <span class="suggested-date">12 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/head-of-nato-warns-Europe-to-get-ready-for-a-potential-conflict-with-russia-first-image.webp"
                            alt="Head of NATO warns Europe to get ready for a potential conflict with Russia first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../world/head-of-nato-warns-Europe-to-get-ready-for-a-potential-conflict-with-russia.php" title="Head of NATO warns Europe to get ready for a potential conflict with Russia" class="suggested-title">Head of NATO warns Europe to get ready for a potential conflict with Russia</a>
                        <span class="suggested-date">12 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/as-central-banks-signal-divergent-policies-global-markets-prepare-first-image.webp"
                            alt="As central banks signal divergent policies, global markets prepare for a pivotal week first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../world/as-central-banks-signal-divergent-policies-global-markets-prepare.php" title="As central banks signal divergent policies, global markets prepare for a pivotal week" class="suggested-title">As central banks signal divergent policies, global markets prepare for a pivotal week</a>
                        <span class="suggested-date">13 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn">
        <i class="fa-solid fa-chevron-up"></i>
    </button>
    <script src="js/style.js"></script>
</body>

</html>