<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>UK special forces accused over killings in Afghanistan</title>
    <meta name="title" content="UK special forces accused over killings in Afghanistan">

    <!-- Meta Description -->
    <meta name="description"
        content="Inquiry evidence suggests UK special forces may have operated a deliberate policy to kill Afghan fighting-age men during operations, raising serious legal concerns.">

    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php">

    <!-- Open Graph -->
    <meta property="og:title" content="UK special forces accused over killings in Afghanistan">
    <meta property="og:description"
        content="Inquiry evidence suggests UK special forces may have operated a deliberate policy to kill Afghan fighting-age men during operations, raising serious legal concerns.">
    <meta property="og:url"
        content="https://www.morenews.org/uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php">
    <meta property="og:image"
        content="https://www.morenews.org/images/uk-special-forces-accused-of-policy-to-kill-afghan-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="UK special forces accused over killings in Afghanistan">
    <meta name="twitter:description"
        content="Inquiry evidence suggests UK special forces may have operated a deliberate policy to kill Afghan fighting-age men during operations, raising serious legal concerns.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/uk-special-forces-accused-of-policy-to-kill-afghan-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=UnifrakturMaguntia&display=swap" rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&family=Noto+Serif+JP:wght@200..900&display=swap"
        rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
        integrity="sha512-DxV+EoADOkOygM4IR9yXP8Sb2qwgidEmeqAEmDKIOfPRQZOWbXCzLC6vjbZyy0vPisbH2SyW27+ddLVCN+OMzQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Favicon -->
    <link rel="icon" href="../images/icon.svg">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "UK",
          "item": "https://www.morenews.org/uk/uk.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "UK special forces accused over killings in Afghanistan",
          "item": "https://www.morenews.org/uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php#webpage",
      "url": "https://www.morenews.org/uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php",
      "name": "UK special forces accused over killings in Afghanistan",
      "description": "Inquiry evidence suggests UK special forces may have operated a deliberate policy to kill Afghan fighting-age men during operations, raising serious legal concerns.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/uk-special-forces-accused-of-policy-to-kill-afghan-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php#article",
      "headline": "UK special forces accused over killings in Afghanistan",
      "description": "Inquiry evidence suggests UK special forces may have operated a deliberate policy to kill Afghan fighting-age men during operations, raising serious legal concerns.",
      "datePublished": "2025-12-01",
      "dateModified": "2025-12-01",
      "articleSection": "UK",
      "inLanguage": "en-GB",
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/uk-special-forces-accused-of-policy-to-kill-afghan-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php#webpage"
      }
    }

  ]
}
</script>

</head>


<body>


<!-- header -->
<?php include '../header.php'; ?>




    <div class="main-container">
        
        <section class="headline-rail">
        </section>
        <div class="article-header">
            <h1 class="article-headline">
                UK special forces accused of policy to kill Afghan fighting-age men
            </h1>

            <div class="article-breadcrumb">
                <a href="../uk/uk.php" class="crumb-link">UK</a> ›
                <span class="crumb-current">UK special forces accused of policy to kill Afghan fighting-age men</span>
            </div>

            <div class="share-icons">
                <a href="#" class="share-btn"><i class="fab fa-facebook-f"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-x-twitter"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-pinterest-p"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-whatsapp"></i></a>
            </div>
        </div>
        <div class="image-wrapper">
            <img src="../images/uk-special-forces-accused-of-policy-to-kill-afghan-first-image.webp" alt="UK special forces accused of policy to kill Afghan fighting-age men first image">
        </div>
        <div class="writer-block">

<!-- author -->
<?php include '../uk-author.php'; ?>



            <div class="story-text-wrap">
                <h2 class="writer-date">1 December 2025</h2>
                <p>
                    An investigation found that members of a British special forces unit in Afghanistan may have killed fighting-age men on "deliberate policy," even if they weren't seen as a threat.  On April 7, 2011, a high-ranking officer known as N1466 wrote to the head of the UK special forces to warn that a commander was worried about how UKSF1 men were acting.  The Afghanistan Inquiry got this information.
                </p>
                <p>
                    The note says that the commanding officer thought that some troops were engaging and killing fighting-aged men "on target even when they weren't a threat," based on complaints from many service members.  N1466 told the panel that the claims were important enough to bring up properly, even though they admitted that they might have been "rumour" or a "wind-up."  He went on to say that UKSF1 members had "consciously chosen" to hide possible wrongdoing.
                </p>
                <p>
                    The disclosure is one piece of evidence that special forces soldiers are shown in private sessions.  The investigation is looking into claims that people were killed without a trial during UK operations in Afghanistan and whether or not high-ranking officials ignored or covered up warnings about wrongdoing.
                </p>
                
            </div>

        </div>
        <div class="image-wrapper">
            <img src="../images/uk-special-forces-accused-of-policy-to-kill-afghan-second-image.webp" alt="UK special forces accused of policy to kill Afghan fighting-age men second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <h3>"Rumour may turn out to be explosive."</h3>
                <p>
                    New evidence given to the Afghanistan Inquiry suggests that senior UK special forces officers may have ignored early warnings about a British unit's possible illegal executions while they were in Afghanistan. N1466, the officer in charge, told the inquiry that he thought higher-ups tried to shut up people who were critical of UKSF1's actions.   He also said that some members of the unit seemed to have a "deliberate policy" of killing Afghan men of fighting age, even when there was no immediate danger.
                </p>

                <p>
                    In a note dated April 7, 2011, N1466 warned N1802, the head of UK special forces, that claims of extrajudicial killings were "distasteful" and not in line with the organization's values.  He said that not doing anything could lead to "explosive" situations. 
                </p>
                <p>
                    N1466 said that N1802 had made a "conscious decision" to hide the problems by changing the content to make it seem like they wanted to downplay the issue. N1466 said that the director did not say whether any of the incidents might have broken the law, even though he agreed that some of the data was strange, like the difference between the number of weapons collected and the number of deaths.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img src="../images/uk-special-forces-accused-of-policy-to-kill-afghan-third-image.webp" alt="UK special forces accused of policy to kill Afghan fighting-age men third image">
        </div>
        <div class="writer-block">
            <div class="story-text-wrap">
                <p>
                    N1802 started looking into the unit's tactics and procedures in April 2011, but N1466 said this was just a way to scare the sub-unit and not to tell the truth. He said he was even more sure that senior leadership chose not to look into the charges because the review was done so quickly and there wasn't enough time for more research.
                </p>

                <p>
                    The investigation also made public notes from a 2018 interview with the Royal Military Police in which N1466 talked about another alleged incident. He talked about how UKSF1 troops shot into a mosquito net over and over again and then saw that the people underneath were still alive. He said that the soldier who killed him later got an award and that the murder was staged to look like it was okay.
                </p>
                <p>
                    N1466 said that the group would have "gone down a sewer" if he hadn't spoken up, which is why he did.He said that the shooting deaths of two young children, Imran and Bilal, who were one and three years old, were an example of behaviour that he thought went against the values of the UK special forces.He said, "This isn't who we are," and "Most of my coworkers would never support or hide such an act."
                </p>
            </div>

        </div>
        
        <div class="writer-block">
            <div class="suggested-box">
                <h3 class="suggested-heading">UK News</h3>

                <div class="suggested-item">
                    <img src="../images/whats-new-in-this-months-redesigned-uk-passports-first-image.webp"
                            alt="What’s new in this month’s redesigned UK passports?" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/whats-new-in-this-months-redesigned-uk-passports.php" title="What’s new in this month’s redesigned UK passports?" class="suggested-title">What’s new in this month’s redesigned UK passports?</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/starmer-reeves-the-pm-denies-misleading-the-cabinet-first-image.webp"
                            alt="Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is proud of the budget" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters.php" title="Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is proud of the budget" class="suggested-title">Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is "proud" of the budget</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators-first-image.webp"
                         alt="When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators.php" title="When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators" class="suggested-title">When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>




    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn">
        <i class="fa-solid fa-chevron-up"></i>
    </button>
    <script src="js/style.js"></script>
</body>

</html>