<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>World Darts Championship under way at Alexandra Palace!</title>
    <meta name="title" content="World Darts Championship under way at Alexandra Palace!">

    <!-- Meta Description (155 chars) -->
    <meta name="description"
        content="The World Darts Championship is under way at Alexandra Palace, with top players competing as packed crowds and global audiences follow the biggest event!!!">

    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace.php">

    <!-- Open Graph -->
    <meta property="og:title" content="World Darts Championship under way at Alexandra Palace!">
    <meta property="og:description"
        content="The World Darts Championship is under way at Alexandra Palace, with top players competing as packed crowds and global audiences follow the biggest event!!!">
    <meta property="og:url"
        content="https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace.php">
    <meta property="og:image"
        content="https://www.morenews.org/images/world-darts-championship-under-way-at-alexandra-palace-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="World Darts Championship under way at Alexandra Palace!">
    <meta name="twitter:description"
        content="The World Darts Championship is under way at Alexandra Palace, with top players competing as packed crowds and global audiences follow the biggest event!!!">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/world-darts-championship-under-way-at-alexandra-palace-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace.php">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=UnifrakturMaguntia&display=swap" rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&family=Noto+Serif+JP:wght@200..900&display=swap"
        rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
        integrity="sha512-DxV+EoADOkOygM4IR9yXP8Sb2qwgidEmeqAEmDKIOfPRQZOWbXCzLC6vjbZyy0vPisbH2SyW27+ddLVCN+OMzQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Favicon -->
    <link rel="icon" href="../images/icon.svg">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/callum-fraser.php#author",
      "name": "Callum Fraser",
      "url": "https://www.morenews.org/author/callum-fraser.php",
      "jobTitle": "Sports Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Sports",
          "item": "https://www.morenews.org/sports/sports.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "World Darts Championship under way at Alexandra Palace!",
          "item": "https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace.php"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace.php#webpage",
      "url": "https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace.php",
      "name": "World Darts Championship under way at Alexandra Palace!",
      "description": "The World Darts Championship is under way at Alexandra Palace, with top players competing as packed crowds and global audiences follow the biggest event!!!",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/world-darts-championship-under-way-at-alexandra-palace-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace.php#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace.php#article",
      "headline": "World Darts Championship under way at Alexandra Palace!",
      "description": "The World Darts Championship is under way at Alexandra Palace, with top players competing as packed crowds and global audiences follow the biggest event!!!",
      "datePublished": "2025-12-11",
      "dateModified": "2025-12-11",
      "articleSection": "Sports",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/callum-fraser.php#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/world-darts-championship-under-way-at-alexandra-palace-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace.php#webpage"
      }
    }

  ]
}
</script>

</head>


<body>

<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               World Darts Championship Under Way at Alexandra Palace
            </h1>

            <div class="article-breadcrumb">
                <a href="../sports/sports.php" class="crumb-link">Sports</a> ›
                <span class="crumb-current">World Darts Championship Under Way at Alexandra Palace</span>
            </div>

            <div class="share-icons">
                <a href="#" class="share-btn"><i class="fab fa-facebook-f"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-x-twitter"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-pinterest-p"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-whatsapp"></i></a>
            </div>
        </div>
        <div class="image-wrapper">
            <img src="../images/world-darts-championship-under-way-at-alexandra-palace-first-image.webp" alt="World Darts Championship Under Way at Alexandra Palace first image">
        </div>
        <div class="writer-block">
            <!-- author -->
<?php include '../sports-author.php'; ?>

            <div class="story-text-wrap">
                <h2 class="writer-date">11 December 2025</h2>
                <p>
                The World Darts Championship, one of the most exciting sporting events, will be held again at Alexandra Palace in north London.
            </p>

                <p>
               The 2025–2026 competition is expected to have a larger field of 128 participants, which shows how the sport is growing around the world.   The prize money also shows that darts is becoming a major professional sport.     The fact that Ally Pally already has thousands of fans makes the sport even more like a carnival.
            </p>
                <p>
                The young star's calmness, ability to score, and brave performances last year amazed the crowd.     He is one of the top candidates to win the Sid Waddell Trophy again this year.
            </p>
                <p>
           Littler has played down the pressure, insisting his focus remains on taking each match as it comes. “This tournament is tough from the first round,” he said ahead of the event. “Everyone here has earned their place, and you can’t afford to look too far ahead.”
        </p>
        <p>
        The championship has already delivered drama in its opening sessions, with early shocks and closely fought matches reminding fans just how unforgiving the format can be. Seeded players face dangerous opponents from the very start, and the longer format means consistency and mental strength are just as important as scoring ability.
    </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img src="../images/world-darts-championship-under-way-at-alexandra-palace-second-image.webp" alt="World Darts Championship Under Way at Alexandra Palace second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
              Alongside Littler, established names such as Michael van Gerwen, Gerwyn Price and former champions from across the globe are bidding to make deep runs, while a new generation of players hope to announce themselves on darts’ biggest stage.
            </p>

                <p>
                   Organisers say the expanded field has helped bring fresh stories and greater international representation to the competition. “The depth of talent in the game right now is incredible,” a PDC spokesperson said. “That’s what makes this championship so special.”
                </p>
                <p>
                    Away from the oche, Alexandra Palace has once again become a festive meeting point for fans, with colourful costumes, loud singalongs and packed evening sessions adding to the unique appeal of the event.
                </p>
                <p>
                   Broadcast to millions worldwide, the World Darts Championship continues to be one of the highlights of the sporting winter, blending elite competition with a distinctive atmosphere few events can match.
                </p>
                <p>
                As the tournament gathers pace, anticipation is building over whether Luke Littler can defend his crown — or whether a new name will emerge to steal the spotlight under the bright lights of Ally Pally.
                </p>
   

            </div>

        </div>


        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Sports</h3>

                <div class="suggested-item">
                    <img src="../images/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season-first-image.webp"
                        alt="British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../sports/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season.php" title="British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close" class="suggested-title">British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close</a>
                        <span class="suggested-date">14 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling-first-image.webp"
                        alt="Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../sports/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling.php" title="Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets" class="suggested-title">Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets</a>
                        <span class="suggested-date">14 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/fa-to-raise-world-cup-ticket-concerns-with-fifa-first-image.webp"
                            alt="FA to raise World Cup ticket concerns with FIFA first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../sports/fa-to-raise-world-cup-ticket-concerns-with-fifa.php" title="FA to raise World Cup ticket concerns with FIFA" class="suggested-title">FA to raise World Cup ticket concerns with FIFA</a>
                        <span class="suggested-date">13 December 2025</span>
                    </div>
                </div>
            </div>

        </div>
        


<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn">
        <i class="fa-solid fa-chevron-up"></i>
    </button>
    <script src="js/style.js"></script>
</body>

</html>