<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax</title>
    <meta name="title" content="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax">

    <!-- Meta Description -->
    <meta name="description"
        content="The UK government confirms it will implement the 2027 Carbon Border Tax despite concerns from businesses about costs and international trade.">

    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php">

    <!-- Open Graph -->
    <meta property="og:title" content="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax">
    <meta property="og:description"
        content="UK officials reiterate that the 2027 Carbon Border Adjustment Mechanism will proceed, addressing carbon emissions from imports.">
    <meta property="og:url"
        content="https://www.morenews.org/politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php">
    <meta property="og:image"
        content="https://www.morenews.org/images/despite-business-concerns-the-uk-will-move-forward-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax">
    <meta name="twitter:description"
        content="UK government confirms the 2027 Carbon Border Adjustment Mechanism will be implemented despite concerns from businesses.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/despite-business-concerns-the-uk-will-move-forward-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=UnifrakturMaguntia&display=swap" rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&family=Noto+Serif+JP:wght@200..900&display=swap"
        rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
        integrity="sha512-DxV+EoADOkOygM4IR9yXP8Sb2qwgidEmeqAEmDKIOfPRQZOWbXCzLC6vjbZyy0vPisbH2SyW27+ddLVCN+OMzQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Favicon -->
    <link rel="icon" href="../images/icon.svg">

    <!-- JSON-LD -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/emily-hargreaves.php#author",
      "name": "Emily Hargreaves",
      "url": "https://www.morenews.org/author/emily-hargreaves.php",
      "jobTitle": "Political Correspondent",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Politics",
          "item": "https://www.morenews.org/politics/politics.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax",
          "item": "https://www.morenews.org/politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php#webpage",
      "url": "https://www.morenews.org/politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php",
      "name": "Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax",
      "description": "The UK government confirms it will implement the 2027 Carbon Border Tax despite concerns from businesses about costs and international trade.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/despite-business-concerns-the-uk-will-move-forward-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php#article",
      "headline": "Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax",
      "description": "UK government confirms the 2027 Carbon Border Adjustment Mechanism will be implemented despite concerns from businesses.",
      "datePublished": "2025-12-04",
      "dateModified": "2025-12-04",
      "articleSection": "Politics",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/emily-hargreaves.php#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/despite-business-concerns-the-uk-will-move-forward-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php#webpage"
      }
    }

  ]
}
</script>
</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax
            </h1>

            <div class="article-breadcrumb">
                <a href="../politics/politics.php" class="crumb-link">Politics</a> ›
                <span class="crumb-current"> Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax</span>
            </div>

            <div class="share-icons">
                <a href="#" class="share-btn"><i class="fab fa-facebook-f"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-x-twitter"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-pinterest-p"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-whatsapp"></i></a>
            </div>
        </div>
        <div class="image-wrapper">
            <img src="../images/despite-business-concerns-the-uk-will-move-forward-first-image.webp" alt="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax first image">
        </div>
        <div class="writer-block">
            <!-- author -->
<?php include '../politics-author.php'; ?>

            <div class="story-text-wrap">
                <h2 class="writer-date">4 December 2025</h2>
                <p>
                 Even though some businesses are worried about how a carbon border tax will affect costs and international trade, the UK government has said again that it will put one in place by 2027.  The Carbon Border Adjustment Mechanism (CBAM) may fine imported goods that release a lot of carbon dioxide during their production.
                </p>

                <p>
                  Under the plan, products that come into the UK market will have to pay extra taxes. These include steel, cement, aluminum, fertilizers, and ceramics.  Products that pollute more will have to pay more in taxes. The amount of carbon released during production will determine how much more.  The government says that the new plan is meant to stop "carbon leakage," which is when companies move their operations to countries with less strict environmental rules to get around local climate regulations.
                </p>
                <p>
                   Ministers say that the plan will stop cheaper, higher-emission imports from hurting UK businesses that are already spending a lot of money on greener technologies.  They also think it's an important part of reaching the UK's legally required net-zero goals.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img src="../images/despite-business-concerns-the-uk-will-move-forward-second-image.webp" alt="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
                    Several businesses and trade groups say that the new tax could raise the cost of imports and make things uncertain for manufacturers who rely on international supply chains.  Business groups have asked for clear rules, help during the transition, and close communication with trading partners to make sure the plan doesn't hurt competition.
                </p>

                <p>
                   The government has said that it will keep talking to businesses before giving out more information, like how the fee will be set up and how emissions will be measured.  Officials say the goal is to connect the UK's system to other systems being set up around the world, like the EU's CBAM, which will start this year.
                </p>
                <p>
                    Ministers say that the policy is still necessary, even though it has been criticized, to make sure that efforts to lower carbon emissions are fair across all sectors and countries.  The government says that the tax will level the playing field for UK manufacturers and encourage more environmentally friendly manufacturing around the world.
                </p>
            </div>

        </div>


        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Politics</h3>

                <div class="suggested-item">
                    <img src="../images/watchdog-discovered-serious-shortcomings-in-vetting-and-misconduct-checks-first-image.webp" 
                        alt="watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/watchdog-discovered-serious-shortcomings-in-vetting-and-misconduct-checks.php" title="watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny" class="suggested-title">watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny</a>
                        <span class="suggested-date">4 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials-first-image.webp" 
                    alt="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials.php" title="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials" class="suggested-title">David Lammy is anticipated to modify his plans to eliminate the majority of jury trials</a>
                        <span class="suggested-date">6 September 2021</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early-first-iamge.webp" 
                        alt="The OBR chair quits after an investigation into how the budget draft was sent out early first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early.php"
                             title="The OBR chair quits after an investigation into how the budget draft was sent out early" class="suggested-title">The OBR chair quits after an investigation into how the budget draft was sent out early</a>
                        <span class="suggested-date">2 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn">
        <i class="fa-solid fa-chevron-up"></i>
    </button>
    <script src="js/style.js"></script>
</body>

</html>