<!DOCTYPE html>
<html lang="en">



<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>Angela Rayner Stresses Labour’s Commitment to Workers’ Rights</title>
    <meta name="title" content="Angela Rayner Stresses Labour’s Commitment to Workers’ Rights">

    <!-- Meta Description -->
    <meta name="description"
        content="Angela Rayner says Labour will strengthen workers’ rights from day one, promising stronger protections and employment reforms early in government.">

    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php">

    <!-- Open Graph -->
    <meta property="og:title" content="Angela Rayner Stresses Labour’s Commitment to Workers’ Rights">
    <meta property="og:description"
        content="Angela Rayner says Labour will strengthen workers’ rights from day one, promising stronger protections and employment reforms early in government.">
    <meta property="og:url"
        content="https://www.morenews.org/politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php">
    <meta property="og:image"
        content="https://www.morenews.org/images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Angela Rayner Stresses Labour’s Commitment to Workers’ Rights">
    <meta name="twitter:description"
        content="Angela Rayner says Labour will strengthen workers’ rights from day one, promising stronger protections and employment reforms.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=UnifrakturMaguntia&display=swap" rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&family=Noto+Serif+JP:wght@200..900&display=swap"
        rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
        integrity="sha512-DxV+EoADOkOygM4IR9yXP8Sb2qwgidEmeqAEmDKIOfPRQZOWbXCzLC6vjbZyy0vPisbH2SyW27+ddLVCN+OMzQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Favicon -->
    <link rel="icon" href="../images/icon.svg">

    <!-- JSON-LD -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/emily-hargreaves.php#author",
      "name": "Emily Hargreaves",
      "url": "https://www.morenews.org/author/emily-hargreaves.php",
      "jobTitle": "Political Correspondent",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Politics",
          "item": "https://www.morenews.org/politics/politics.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Angela Rayner Stresses Labour’s Commitment to Workers’ Rights",
          "item": "https://www.morenews.org/politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php#webpage",
      "url": "https://www.morenews.org/politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php",
      "name": "Angela Rayner Stresses Labour’s Commitment to Workers’ Rights",
      "description": "Angela Rayner says Labour will strengthen workers’ rights from day one, promising stronger protections and employment reforms.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php#article",
      "headline": "Angela Rayner Stresses Labour’s Commitment to Workers’ Rights",
      "description": "Angela Rayner says Labour will strengthen workers’ rights from day one as part of planned employment law reforms.",
      "datePublished": "2025-12-01",
      "dateModified": "2025-12-01",
      "articleSection": "Politics",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/emily-hargreaves.php#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php#webpage"
      }
    }

  ]
}
</script>

</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               Angela Rayner stressed Labour's commitment to workers' rights from the start during major employment changes.
            </h1>

            <div class="article-breadcrumb">
                <a href="../politics/politics.php" class="crumb-link">Politics</a> ›
                <span class="crumb-current">Angela Rayner stressed Labour's commitment to workers' rights from the start during major employment changes.</span>
            </div>

            <div class="share-icons">
                <a href="#" class="share-btn"><i class="fab fa-facebook-f"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-x-twitter"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-pinterest-p"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-whatsapp"></i></a>
            </div>
        </div>
        <div class="image-wrapper">
            <img src="../images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-first-image.webp" alt="Angela Rayner stressed Labour's commitment to workers' rights from the start during major employment changes first image">
        </div>
        <div class="writer-block">
            <!-- author -->
<?php include '../politics-author.php'; ?>

            <div class="story-text-wrap">
                <h2 class="writer-date">1 December 2025</h2>
                <p>
                    As part of Labour's upcoming workers' rights bill, Deputy Prime Minister Angela Rayner said again that the government wants to offer protections for workers on their first day of work. She said that ministers are getting ready to introduce the changes early in the parliamentary term. The package is the main part of Labour's New Deal for Working People, a plan to modernize the UK's employment system, make it safer for workers, and give them more job security. Unions and experts in the labor market have been criticizing it for years.
                </p>

                <p>
                  Rayner says that the government wants to make sure that all workers, no matter how long they have been with the company, have basic protections against unfair treatment. Labour promised to give workers more rights against wrongful termination, better protections for workers on unstable or uncertain contracts, easier access for trade unions to companies, and a better way to enforce laws against unfair employment practices. She stressed that "workers should not be left vulnerable just because they are new to a role." She also said that the changes are meant to make the balance between employee stability and employer flexibility more fair.
                </p>
                <p>
                    The deal "guarantees that UK pharmaceutical exports worth at least £5 billion annually will continue to enter the US without tariffs," said Peter Kyle, the secretary of business and trade. He continued by saying that the plan will promote investment and help maintain highly skilled jobs in the UK's bio sciences sector.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img src="../images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-second-image.webp" alt="Angela Rayner stressed Labour's commitment to workers' rights from the start during major employment changes second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
                    Trade unions have mostly backed the government's plans, calling them the most ambitious attempt in decades to improve workers' rights. Union leaders say that industries like retail, hospitality, and social care, where workers leave and come back a lot and job security is still a big problem, need protections from day one. Business groups have responded by working together and being careful. Some companies have expressed concerns about how quickly things are changing, but most have said they are willing to talk as long as the transition is done correctly.
                </p>

                <p>
                    The government hasn't released the final language of the bill yet, but ministers say they are still talking to businesses, unions, and legal experts about it. Rayner has said that the government will try to pass the legislation as soon as possible because many of the reforms are meant to take effect early in the government's term to fix problems in the labor market that have been around for a long time.
                </p>
                <p>
                    The administration says that both businesses that want clear and stable rules across the economy and workers who want stability would benefit from a new framework based on fairness and clarity. Rayner says that the government wants to create a labor market that encourages long-term growth by making working conditions better and giving workers more legal protections.
                </p>
            </div>

        </div>


        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Politics</h3>

                <div class="suggested-item">
                    <img src="../images/despite-business-concerns-the-uk-will-move-forward-first-image.webp"
                         alt="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php" title="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax" class="suggested-title">Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax</a>
                        <span class="suggested-date">4 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/watchdog-discovered-serious-shortcomings-in-vetting-and-misconduct-checks-first-image.webp" 
                        alt="watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/watchdog-discovered-serious-shortcomings-in-vetting-and-misconduct-checks.php" title="watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny" class="suggested-title">watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny</a>
                        <span class="suggested-date">4 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials-first-image.webp" 
                    alt="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials.php" title="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials" class="suggested-title">David Lammy is anticipated to modify his plans to eliminate the majority of jury trials</a>
                        <span class="suggested-date">6 September 2021</span>
                    </div>
                </div>
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>


    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn">
        <i class="fa-solid fa-chevron-up"></i>
    </button>
    <script src="js/style.js"></script>
</body>

</html>