<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

 
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=UnifrakturMaguntia&display=swap" rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&family=Noto+Serif+JP:wght@200..900&display=swap"
        rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
        integrity="sha512-DxV+EoADOkOygM4IR9yXP8Sb2qwgidEmeqAEmDKIOfPRQZOWbXCzLC6vjbZyy0vPisbH2SyW27+ddLVCN+OMzQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <title>More News – UK Politics, Business, Tech & World</title>
    <meta name="title" content="More News – UK Politics, Business, Tech & World">

    <!-- Meta Description -->
    <meta name="description"
    content="More News brings trusted UK reporting on politics, business, technology, world affairs, health and sports with independent journalism and clear analysis.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/">

    <!-- Open Graph (Facebook / LinkedIn) -->
    <meta property="og:title" content="More News – UK Politics, Business, Tech & World">
    <meta property="og:description"
    content="More News brings trusted UK reporting on politics, business, technology, world affairs, health and sports with independent journalism and clear analysis.">
    <meta property="og:url" content="https://www.morenews.org/">
    <meta property="og:image" content="https://www.morenews.org/images/logo.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="More News – UK Politics, Business, Tech & World">
    <meta name="twitter:description"
    content="More News brings trusted UK reporting on politics, business, technology, world affairs, health and sports with independent journalism and clear analysis.">
    <meta name="twitter:url" content="https://www.morenews.org/">
    <meta name="twitter:image" content="https://www.morenews.org/images/logo.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="css/style.css" as="style">
    <link rel="stylesheet" href="css/style.css">

    <!-- Favicon -->
     <link rel="icon" href="images/icon.svg">

</head>

<body>

    <!-- header -->
 <?php include 'index-header.php'; ?>


    <div class="main-container">

    <section class="headline-rail" >
            <div class="rail-inner">
                <article class="rail-item">
                    <a href="uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet.php" title="Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet" class="thumb-wrap">
                        <img src="images/darren-jones-defends-rachel-reeves-for-misrepresenting-first-image.webp"
                            alt="Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet">
                    </a>
                    <div class="rail-content">
                        <h3 class="rail-title">
                            <a href="uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet.php" title="Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet">Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet</a>
                        </h3>
                        <p class="rail-excerpt">PM’s chief secretary denies any lying as Reeves faces claims she hid OBR surplus forecasts.</p>
                    </div>
                </article>

                <article class="rail-item">
                    <a href="uk/uk-special-forces-accused-of-policy-to-kill-Afghan-fighting-age-men.php" title="UK special forces accused of policy to kill Afghan fighting-age men" class="thumb-wrap">
                        <img src="images/uk-special-forces-accused-of-policy-to-kill-afghan-first-image.webp"
                            alt="UK special forces accused of policy to kill Afghan fighting-age men">
                    </a>
                    <div class="rail-content">
                        <h3 class="rail-title">
                            <a href="uk/uk-special-forces-accused-of-policy-to-kill-Afghan-fighting-age-men.php" title="UK special forces accused of policy to kill Afghan fighting-age men">UK special forces accused of policy to kill Afghan fighting-age men</a>
                        </h3>
                        <p class="rail-excerpt">According to a senior commander, he alerted the leadership of the UK special forces, but they "consciously decided" to conceal it.</p>
                    </div>
                </article>

                <article class="rail-item">
                    <a href="uk/whats-new-in-this-months-redesigned-uk-passports.php" title="What’s new in this month’s redesigned UK passports?" class="thumb-wrap">
                        <img src="images/whats-new-in-this-months-redesigned-uk-passports-first-image.webp"
                            alt="what’s new in this month’s redesigned UK passports?">
                    </a>
                    <div class="rail-content">
                        <h3 class="rail-title">
                            <a href="uk/whats-new-in-this-months-redesigned-uk-passports.php" title="What’s new in this month’s redesigned UK passports?">What’s new in this month’s redesigned UK passports?</a>
                        </h3>
                        <p class="rail-excerpt">The Home Office says this is the first fully new UK passport design in five years. Here are the key changes and their impact.</p>
                    </div>
                </article>

            </div>
        </section>
         
        <section class="news-feature">
            <div class="news-container">

                <div class="news-left">
                    <h2 class="news-title"><a href="uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters.php" title="Starmer-Reeves : The PM denies misleading the cabinet or voters">Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is "proud" of the budget</a></h2>
                    <div class="news-meta">
                        <span class="category">UK</span>
                        <span class="author">Jeremiah Polom</span>
                    </div>
                    <p class="news-excerpt">
                    Sir Keir Starmer termed Rachel Reeves' controversial wage, social, and child poverty budget a "moment of personal pride." Quote: "There was no misleading." Despite a £4 billion excess, Reeves denied deception. As Starmer explains, welfare makes people impoverished. He urged the UK to "face the facts" about Brexit and repair EU relations.
                </p>
                </div>

                <div class="news-image">
                    <img src="images/starmer-reeves-the-pm-denies-misleading-the-cabinet-first-image.webp"
                        alt="Starmer Reeves The PM denies misleading the cabinet or voters">
                </div>

                <div class="news-right">
                    <div class="news-top">
                        <div class="news-small">
                            <a class="link1" href="uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators.php" title="When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators">When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators</a>
                            <p>Revolut failed to notify UK authorities that CEO Nik Storonsky lived in the UAE before documents showed this, raising worries while the fintech awaits a banking licence. After his family office listed him in the UAE and Revolut in the UK, authorities requested reassurance, but the company said the transfer had no influence on management.gement.
                            </p>
                        </div>
                        <div class="news-small">
                            <a class="link1" href="uk/us-and-uk-agree-to-zero-pharmaceutical-tariffs.php" title="US and UK agree to zero pharmaceutical tariffs">US and UK agree to zero pharmaceutical tariffs</a>
                            <p>In exchange for three years of no tariffs on British drugs, the UK agreed to spend more on NHS drugs and make it harder for new treatments to get approved. The government says the move protects a major export industry after threats of US tariffs, but experts say it could cost the NHS billions as pharmaceutical companies leave the UK.
                            </p>
                        </div>
                    </div>
                    <div class="news-bottom">
                        <a class="link1" href="uk/uk-wanted-to-rejoin-erasmus-student-exchange.php" title="UK wanted to rejoin Erasmus student exchange">UK wanted to rejoin Erasmus student exchange</a>
                        <p>As part of efforts to improve relations after Brexit, a deal to rejoin Erasmus from 2027 is expected in January. France may fight the UK's ban on importing foie gras, even though the decision comes after talks on defense, mobility, food standards, and carbon laws have stalled.
                        </p>
                    </div>
                </div>
            </div>
        </section>
        <section class="story-wrapper">
            <div class="story-grid">
                <div class="primary-feed">

                    <div class="headline-duo">
                        <article class="headline-card">
                            <a href="politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials.php" title="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials" class="headline-title">David Lammy is anticipated to modify his plans to eliminate the majority of jury trials</a>
                            <p class="headline-summary">
                            After getting "cabinet feedback," the justice secretary says he will stick to Leveson's suggested three-year sentence level.
                            </p>
                        </article>

                        <article class="headline-card">
                            <a href="politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early.php" title="The OBR chair quits after an investigation into how the budget draft was sent out early" class="headline-title">
                                The OBR chair quits after an investigation into how the budget draft was sent out early
                            </a>
                            <p class="headline-summary">
                                Richard Hughes takes "full responsibility" for the watchdog mistake while Starmer tries to get the job of chancellor.
                            </p>
                        </article>
                    </div>

                    <div class="feature-block">
                        <div class="feature-text">
                            <a href="politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php" title="Angela Rayner will propose a change to expedite the workers' rights bill" class="feature-title">Angela Rayner will propose a change to expedite the workers' rights bill</a>
                            <div class="meta-line">
                                <span class="topic-tag">Politics</span>
                                <span class="byline">James Thornton</span>
                            </div>
                            <div class="dis-flex">
                                <p class="feature-summary">
                                   Angela Rayner has confirmed that Labour’s forthcoming workers’ rights bill will introduce day-one protections against unfair treatment, with ministers preparing to move the legislation forward early in the parliamentary term. The reforms, which form a key part of Labour’s New Deal for Working People, are designed to modernise employment rules, improve job stability and strengthen enforcement.
                                </p>
                                <p class="feature-summary">
                                    Trade unions have broadly backed the plans, while businesses are responding with caution but remain willing to engage. Rayner says the changes will be introduced swiftly to address long-standing weaknesses in the labour market and to build a fairer and more predictable system for both employees and employers.
                                 </p>
                            </div>
                        </div>
                        <div class="feature-media">
                            <img src="images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-first-image.webp"
                                alt="Angela Rayner will propose a change to expedite the workers' rights bill">
                        </div>
                    </div>

 
                    <section class="category-block">

                        <div class="category-grid">
                            <!-- Left Column -->
                            <div class="category-left">
                                <div class="story-info">
                                    <a href="politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php" title="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax" class="story-title">
                                        Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax
                                    </a>
                                    <div class="story-meta">
                                        <span class="story-tag">Politics</span>
                                        <span class="story-author">Jeremiah Polom</span>
                                    </div>
                                    <p class="story-excerpt">
                                      The UK will put a carbon border tax in place by 2027. This will make things that emit a lot of carbon, like cement and steel, more expensive. Businesses say it could raise costs and cause problems in the supply chain.
                                    </p>
                                </div>
                                <div class="story-photo">
                                    <img src="images/despite-business-concerns-the-uk-will-move-forward-first-image.webp"
                                        alt="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax">
                                </div>
                            </div>

                            <!-- Right Column -->
                            <div class="category-right">
                                <a href="politics/watchdog-discovered-serious-shortcomings-in-vetting-and-misconduct-checks.php" title="watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny" class="side-title2">
                                    watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny
                                </a>
                                <p class="side-excerpt">
                                   Thousands of policemen may have been hired without adequate background checks, according to the HM Inspectorate.The Metropolitan Police have come under more fire after a watchdog found serious problems with their screening and misconduct procedures.
                                </p>
                            </div>
                        </div>
                    </section>

                </div>

                <!-- Sidebar -->
                <aside class="side-feed">

                    <div class="side-card image-inline">
                        <div class="">
                            <p class="side-tag">Business</p>
                            <h4 class="side-title"><a href="business/bt-introduces-the-sovereign-data-platform-to-fulfill-the-needs-of-the-uk-digital-infrastructure.php" title="BT Introduces the Sovereign Data Platform to Fulfill the Needs of the UKs Digital Infrastructure">BT Introduces the "Sovereign Data" Platform to Fulfill the Needs of the UK's Digital Infrastructure</a>
                            </h4>
                            <span class="side-author">Henry Whitaker</span>
                        </div>
                        <img src="images/bt-introduces-the-sovereign-data-platform-first-image.webp"
                            alt="BT Introduces the Sovereign Data Platform to Fulfill the Needs of the UK Digital Infrastructure">
                    </div>

                    <div class="side-card image-inline">
                        <div>
                            <p class="side-tag">Business</p>
                            <h4 class="side-title"><a href="business/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget.php" title="Whitbread warns that a rise in property taxes linked to the budget might cost millions of dollars">Whitbread warns that a rise in property taxes linked to the budget might cost millions of dollars</a></h4>
                            <span class="side-author">Henry Whitaker</span>
                        </div>
                        <img src="images/whitbread-warns-that-a-rise-in-property-taxes-linked-to-the-budget-first-image.webp"
                            alt="Whitbread warns that a rise in property taxes linked to the budget might cost millions of dollars first image">
                    </div>

                    <div class="side-card image-inline">
                        <div>
                            <p class="side-tag">Business</p>
                            <h4 class="side-title"><a href="business/retail-stocks-rise-following-small-store-business-rates-reform.php" title="Retail Stocks Rise Following Small-Store Business-Rates Reform">Retail Stocks Rise Following Small-Store Business-Rates Reform</a>
                            </h4>
                            <span class="side-author">Henry Whitaker</span>
                        </div>
                        <img src="images/retail-stocks-rise-following-small-store-business-rates-reform-first-image.webp"
                            alt="Retail Stocks Rise Following Small-Store Business-Rates Reform first image">
                    </div>

                    <div class="">
                        <img class="image-sect"
                            src="images/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-first-image.webp"
                            alt="UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines">
                    </div>
                    <section class="crisis-wrap">
                        <div class="crisis-container">

                            <!-- Main Heading -->
                            <a href="business/uk-companies-reduce-employment-at-the-quickest-rate-since-2021-construction-activity-declines.php" title="UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines" class="crisis-title">
                                UK Companies Reduce Employment at the Quickest Rate Since 2021; Construction Activity Declines
                            </a>
                            <p class="crisis-summary">
                                UK businesses are cutting jobs at the fastest rate since 2021, while construction activity has fallen to its lowest level since the early pandemic. The downturn is being linked to weak demand, postponed investment and uncertainty surrounding upcoming tax and budget changes.
                            </p>


                        </div>
                    </section>

                </aside>
            </div>
        </section>
        <!-- ====== Section Start ====== -->
        <section class="insight-board">
            <div class="insight-row">

                <div class="insight-item">

                    <div class="">
                        <a href="tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy.php" title="MBDA UK wins £316 million contract for laser-based anti-drone technology for the Royal Navy" class="insight-title">MBDA UK wins £316 million contract for laser-based anti-drone technology for the Royal Navy</a>
                        
                    </div>
                    <div class="">
                        <img src="images/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology.webp"
                            alt="MBDA UK wins £316 million contract for laser-based anti-drone technology for the Royal Navy" class="insight-thumb">
                    </div>
                </div>

                <div class="insight-item">

                    <div class="">
                        <a href="tech/ai-adoption-slashes-workloads-at-uk-firms.php" title="AI adoption slashes workloads at UK firms – and may offer a long-awaited boost to national productivity" class="insight-title">AI adoption slashes workloads at UK firms – and may offer a long-awaited boost to national productivity</a>
                    </div>
                    <div class="">
                        <img src="images/ai-adoption-slashes-workloads-at-uk-firms-first-image.webp"
                            alt="AI adoption slashes workloads at UK firms – and may offer a long-awaited boost to national productivity" class="insight-thumb">
                    </div>
                </div>


                <div class="insight-item">

                    <div class="">
                        <a href="tech/nhs-trials-next-generation-medical-technologies-from-ai-diagnostics.php" title="NHS Trials Next-Generation Medical Technologies, from AI Diagnostics to 3D Imaging" class="insight-title">NHS Trials Next-Generation Medical Technologies, from AI Diagnostics to 3D Imaging</a>
                    </div>
                    <div class="">
                        <img src="images/nhs-trials-next-generation-medical-technologies-from-ai-diagnostics-first-image.webp"
                            alt="NHS Trials Next-Generation Medical Technologies, from AI Diagnostics to 3D Imaging first iamge" class="insight-thumb">
                    </div>
                </div>


                <div class="insight-item">

                    <div class="">
                        <a href="tech/uk-defence-tech-accelerates-with-breakthroughn-in-robotics.php" title="UK Defence Tech Accelerates with Breakthroughs in Robotics, Undersea Systems and AI" class="insight-title">UK Defence Tech Accelerates with Breakthroughs in Robotics, Undersea Systems and AI</a>
                    </div>
                    <div class="">
                        <img src="images/uk-defence-tech-accelerates-with-breakthroughn-in-robotics-first-image.webp"
                            alt="UK Defence Tech Accelerates with Breakthroughs in Robotics, Undersea Systems and AI first image" class="insight-thumb">
                    </div>
                </div>



            </div>
        </section>
        <!-- ====== Section End ====== -->
        <section class="journal-wrapper">
            <div class="feature-grid">

                <article class="story-block">
                    <div class="story-visual">
                        <img src="images/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate-first-image.webp"
                            alt="IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate first image">
                    </div>
                    <h2 class="story-heading"><a href="world/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate.php" title="IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate">IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate</a></h2>
                    <p class="story-excerpt">The IOC says Russian and Belarusian youth athletes should be allowed to compete under their national flags, while senior-level restrictions remain.</p>
                    <hr class="story-divider">
                </article>

                <article class="story-block">
                    <div class="story-visual">
                        <img src="images/a-big-international-interpol-operation-saves-almost-30000-animals-first-image.webp"
                            alt="A big international Interpol operation saves almost 30,000 animals that were trafficked">
                    </div>
                    <h2 class="story-heading"><a href="world/a-big-international-interpol-operation-saves-almost-30000-animals.php" title="A big international Interpol operation saves almost 30,000 animals that were trafficked.">A big international Interpol operation saves almost 30,000 animals that were trafficked</a></h2>
                    <p class="story-excerpt">Interpol’s Operation Thunder 2025 rescued nearly 30,000 trafficked animals in a major global wildlife crackdown.</p>
                    <hr class="story-divider">
                </article>

                <article class="story-block">
                    <div class="story-visual">
                        <img src="images/head-of-nato-warns-Europe-to-get-ready-for-a-potential-conflict-with-russia-first-image.webp"
                            alt="Head of NATO warns Europe to get ready for a potential conflict with Russia first image">
                    </div>
                    <h2 class="story-heading"><a href="world/head-of-nato-warns-Europe-to-get-ready-for-a-potential-conflict-with-russia.php" title="Head of NATO warns Europe to get ready for a potential conflict with Russia">Head of NATO warns Europe to get ready for a potential conflict with Russia</a></h2>
                    <p class="story-excerpt">NATO chief Mark Rutte warns Europe must prepare for a possible conflict with Russia, urging increased defence spending.</p>
                    <hr class="story-divider">
                </article>

                <article class="story-block">
                    <div class="story-visual">
                        <img src="images/as-central-banks-signal-divergent-policies-global-markets-prepare-first-image.webp"
                            alt="As central banks signal divergent policies, global markets prepare for a pivotal week first image">
                    </div>
                    <h2 class="story-heading"><a href="world/as-central-banks-signal-divergent-policies-global-markets-prepare.php" title="As central banks signal divergent policies, global markets prepare for a pivotal week">As central banks signal divergent policies, global markets prepare for a pivotal week</a></h2>
                    <p class="story-excerpt">Global markets face a pivotal week as major central banks move in different policy directions uncertainty in currencies.</p>
                    <hr class="story-divider">
                </article>
 
                <article class="story-block">
                    <div class="story-visual">
                        <img src="images/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns-first-image.webp"
                            alt="Amid widespread anti-corruption demonstrations, Bulgaria's government resigns first image">
                    </div>
                    <h2 class="story-heading"><a href="world/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns.php" title="Amid widespread anti-corruption demonstrations, Bulgaria's government resigns">Amid widespread anti-corruption demonstrations, Bulgaria's government resigns</a></h2>
                    <p class="story-excerpt">Bulgaria’s prime minister has resigned amid mass protests over corruption and rising living costs.</p>
                    <hr class="story-divider">
                </article>

            </div>

            <!-- Sponsor -->
            <div class="sponsor-box">
                <!-- <div class="sponsor-note">- A Word From Our Sponsors -</div> -->
                <div class="sponsor-banner">
                    <img src="images/thatcapitalism.webp"
                        alt="That Capitalism">
                </div>
            </div>
        </section>
        <section class="newsFlexWrap">

            <div class="newsColumnBox">
                <div class="newsImageBox">
                    <img src="images/new-mpox-variant-detected-in-england-first-image.webp"
                        alt="New Mpox Variant Detected in England as Health Officials Step Up Monitoring first image">
                </div>
                <div class="categoryLabel">Health</div>
                <a href="health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring.php" title="New Mpox Variant Detected in England as Health Officials Step Up Monitoring" class="headlineAnchor">New Mpox Variant Detected in England as Health Officials Step Up Monitoring</a>
                
            </div>

            <div class="newsColumnBox">
                <div class="newsImageBox">
                    <img src="images/nhs-faces-record-flu-surge-as-hospitals-brace-first-image.webp"
                        alt="NHS Faces Record Flu Surge as Hospitals Brace for ‘Worst-Case’ Winter Pressure first image">
                </div>
                <div class="categoryLabel">Health</div>
                <a href="health/nhs-faces-record-flu-surge-as-hospitals-brace-for-worst-case-winter-pressure.php" title="NHS Faces Record Flu Surge as Hospitals Brace for ‘Worst-Case’ Winter Pressure" class="headlineAnchor">NHS Faces Record Flu Surge as Hospitals Brace for ‘Worst-Case’ Winter Pressure</a>
                
            </div>

            <div class="newsColumnBox">
                <div class="newsImageBox">
                    <img src="images/king-charles-says-cancer-treatment-will-be-reduced-first-image.webp"
                        alt="King Charles III Says Cancer Treatment Will Be Reduced After Positive Progress first image">
                </div>
                <div class="categoryLabel">Health</div>
                <a href="health/king-charles-says-cancer-treatment-will-be-reduced-after-positive-progress.php" title="King Charles III Says Cancer Treatment Will Be Reduced After Positive Progress" class="headlineAnchor">King Charles III Says Cancer Treatment Will Be Reduced After Positive Progress</a>
            </div>

            <div class="newsColumnBox">
                <div class="newsImageBox">
                    <img src="images/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season-first-image.webp"
                        alt="British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close first image">
                </div>
                <div class="categoryLabel">Sports</div>
                <a href="sports/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season.php" title="British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close" class="headlineAnchor">British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close</a>
            </div>

            <div class="newsColumnBox">
                <div class="newsImageBox">
                    <img src="images/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling-first-image.webp"
                        alt="Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets first image">
                </div>
                <div class="categoryLabel">Sports</div>
                <a href="sports/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling.php" title="Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets" class="headlineAnchor">Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets</a>
            </div>

        </section>
        
        <!-- footer -->
<?php include 'index-footer.php'; ?>


    </div>
    
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn">
        <i class="fa-solid fa-chevron-up"></i>
    </button>

    <script src="js/style.js"></script>
</body>

</html>