<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism</title>
    <meta name="title" content="UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism">

    <!-- Meta Description -->
    <meta name="description"
        content="The UK advertising watchdog bans misleading health ads falsely claiming to diagnose or treat ADHD and autism.">

    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/health/uk-watchdog-bans-misleading-health-ads-claiming-to-treat-adhd-and-autism.php">

    <!-- Open Graph -->
    <meta property="og:title" content="UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism">
    <meta property="og:description"
        content="UK regulators ban misleading ads that falsely claim to diagnose or treat ADHD and autism.">
    <meta property="og:url"
        content="https://www.morenews.org/health/uk-watchdog-bans-misleading-health-ads-claiming-to-treat-adhd-and-autism.php">
    <meta property="og:image"
        content="https://www.morenews.org/images/uk-watchdog-bans-misleading-health-ads-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism">
    <meta name="twitter:description"
        content="UK regulators crack down on misleading health adverts targeting ADHD and autism.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/uk-watchdog-bans-misleading-health-ads-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/health/uk-watchdog-bans-misleading-health-ads-claiming-to-treat-adhd-and-autism.php">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=UnifrakturMaguntia&display=swap" rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&family=Noto+Serif+JP:wght@200..900&display=swap"
        rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
        integrity="sha512-DxV+EoADOkOygM4IR9yXP8Sb2qwgidEmeqAEmDKIOfPRQZOWbXCzLC6vjbZyy0vPisbH2SyW27+ddLVCN+OMzQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Favicon -->
    <link rel="icon" href="../images/icon.svg">

    <!-- JSON-LD -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/lydia-prescott.php#author",
      "name": "Lydia Prescott",
      "url": "https://www.morenews.org/author/lydia-prescott.php",
      "jobTitle": "Health Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/health/uk-watchdog-bans-misleading-health-ads-claiming-to-treat-adhd-and-autism.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Health",
          "item": "https://www.morenews.org/health/health.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism",
          "item": "https://www.morenews.org/health/uk-watchdog-bans-misleading-health-ads-claiming-to-treat-adhd-and-autism.php"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/health/uk-watchdog-bans-misleading-health-ads-claiming-to-treat-adhd-and-autism.php#webpage",
      "url": "https://www.morenews.org/health/uk-watchdog-bans-misleading-health-ads-claiming-to-treat-adhd-and-autism.php",
      "name": "UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism",
      "description": "UK regulators ban misleading health adverts falsely claiming to treat ADHD and autism.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/uk-watchdog-bans-misleading-health-ads-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/health/uk-watchdog-bans-misleading-health-ads-claiming-to-treat-adhd-and-autism.php#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/health/uk-watchdog-bans-misleading-health-ads-claiming-to-treat-adhd-and-autism.php#article",
      "headline": "UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism",
      "description": "The UK advertising watchdog bans misleading health ads falsely claiming to diagnose or treat ADHD and autism.",
      "datePublished": "2025-12-14",
      "dateModified": "2025-12-14",
      "articleSection": "Health",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/lydia-prescott.php#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/uk-watchdog-bans-misleading-health-ads-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/health/uk-watchdog-bans-misleading-health-ads-claiming-to-treat-adhd-and-autism.php#webpage"
      }
    }

  ]
}
</script>

</head>


<body>

<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism
            </h1>

            <div class="article-breadcrumb">
                <a href="../health/health.php" class="crumb-link">Health</a> ›
                <span class="crumb-current">UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism</span>
            </div>

            <div class="share-icons">
                <a href="#" class="share-btn"><i class="fab fa-facebook-f"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-x-twitter"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-pinterest-p"></i></a>
                <a href="#" class="share-btn"><i class="fab fa-whatsapp"></i></a>
            </div>
        </div>
        <div class="image-wrapper">
            <img src="../images/uk-watchdog-bans-misleading-health-ads-first-image.webp" alt="UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism first image">
        </div>
        <div class="writer-block">
            <!-- author -->
<?php include '../health-author.php'; ?>

            <div class="story-text-wrap">
                <h2 class="writer-date">14 December 2025</h2>
                <p>
                 The UK’s advertising watchdog has banned a series of social media adverts that falsely claimed to diagnose or treat conditions such as ADHD and autism, in a move aimed at tackling harmful health misinformation online.
                </p>

                <p>
                The Advertising Standards Authority (ASA) said the adverts, which promoted supplements, tests and alternative remedies, breached strict UK advertising rules by making unproven medical claims. Regulators stressed that ADHD and autism are neurodevelopmental conditions and cannot be “cured” by products sold without clinical evidence.
            </p>
                <p>
                The banned adverts appeared across platforms including Facebook and Instagram and were targeted at parents and adults seeking answers for behavioural or developmental concerns. Some suggested that simple tests or natural products could reverse symptoms, claims the ASA said were misleading and potentially damaging.
            </p>
                <p>
            In its rulings, the watchdog said the advertisers had failed to provide robust scientific evidence to support their claims. Under UK law, products that claim to diagnose, treat or cure medical conditions must meet the same standards as licensed medicines — something these products did not do.
        </p>
        <p>
            A spokesperson for the ASA said the action was part of a wider crackdown on health-related misinformation, particularly content that preys on vulnerable people. “Claims about serious conditions must be accurate, responsible and supported by strong evidence,” the spokesperson said. “Where advertisers fall short, we will act.”
        </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img src="../images/uk-watchdog-bans-misleading-health-ads-second-image.webp" alt="UK Watchdog Bans Misleading Health Ads Claiming to Treat ADHD and Autism second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
                Health experts and charities welcomed the decision, warning that misleading claims can cause real harm. They say families may delay seeking professional medical advice or spend significant amounts of money on ineffective products in the hope of quick solutions.
            </p>

                <p>
                    “People living with ADHD or autism deserve proper support and evidence-based care,” one specialist said. “Suggesting these conditions can be treated or cured by unregulated products risks spreading false hope and undermining trust in healthcare.”
               </p>
                <p>
                    The ASA has increased its focus on online advertising in recent years as social media becomes a primary source of health information for many people. Regulators say digital platforms allow misleading content to spread rapidly, making enforcement more challenging but also more urgent.
                </p>
                <p>
                    Businesses that break the rules must take down or change their ads. They are also told that if they keep breaking the rules, they may face more penalties, such as being reported to trade standards.
                </p>
                <p>
                    The watchdog is telling customers to talk to licensed medical professionals and to be careful about health claims they see online.   It also urges people to report ads that they think might be misleading.
                </p>
                <p>
                    As pressure grows on regulators to rein in online misinformation, the ASA says its message to advertisers is clear: when it comes to health, unproven claims will not be tolerated.
                </p>    

            </div>

        </div>


        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Health</h3>

                <div class="suggested-item">
                    <img src="../images/new-mpox-variant-detected-in-england-first-image.webp"
                        alt="New Mpox Variant Detected in England as Health Officials Step Up Monitoring first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../health/new-mpox-variant-detected-in-england-as-health-officials-step-up-monitoring.php" title="New Mpox Variant Detected in England as Health Officials Step Up Monitoring" class="suggested-title">New Mpox Variant Detected in England as Health Officials Step Up Monitoring</a>
                        <span class="suggested-date">13 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/nhs-faces-record-flu-surge-as-hospitals-brace-first-image.webp"
                        alt="NHS Faces Record Flu Surge as Hospitals Brace for ‘Worst-Case’ Winter Pressure first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../health/nhs-faces-record-flu-surge-as-hospitals-brace-for-worst-case-winter-pressure.php" title="NHS Faces Record Flu Surge as Hospitals Brace for ‘Worst-Case’ Winter Pressure" class="suggested-title">NHS Faces Record Flu Surge as Hospitals Brace for ‘Worst-Case’ Winter Pressure</a>
                        <span class="suggested-date">13 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img src="../images/king-charles-says-cancer-treatment-will-be-reduced-first-image.webp"
                        alt="King Charles III Says Cancer Treatment Will Be Reduced After Positive Progress first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../health/king-charles-says-cancer-treatment-will-be-reduced-after-positive-progress.php" title="King Charles III Says Cancer Treatment Will Be Reduced After Positive Progress" class="suggested-title">King Charles III Says Cancer Treatment Will Be Reduced After Positive Progress</a>
                        <span class="suggested-date">14 December 2025</span>
                    </div>
                </div>
            </div>

        </div>
        


<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn">
        <i class="fa-solid fa-chevron-up"></i>
    </button>
    <script src="js/style.js"></script>
</body>

</html>