<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=UnifrakturMaguntia&display=swap" rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&family=Noto+Serif+JP:wght@200..900&display=swap"
        rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
        integrity="sha512-DxV+EoADOkOygM4IR9yXP8Sb2qwgidEmeqAEmDKIOfPRQZOWbXCzLC6vjbZyy0vPisbH2SyW27+ddLVCN+OMzQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- SEO -->
    <title>About More News | Independent Global Journalism Platform</title>
    <meta name="title" content="About More News | Independent Global Journalism Platform">
    <meta name="description"
        content="Learn more about More News, an independent digital journalism platform delivering trusted reporting, analysis and in-depth coverage of global and UK affairs.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/about.php">

    <!-- Open Graph -->
    <meta property="og:title" content="About More News | Independent Global Journalism Platform">
    <meta property="og:description"
        content="Learn more about More News, an independent digital journalism platform delivering trusted reporting, analysis and in-depth coverage of global and UK affairs.">
    <meta property="og:url" content="https://www.morenews.org/about.php">
    <meta property="og:image" content="https://www.morenews.org/images/morenews-about.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="About More News | Independent Global Journalism Platform">
    <meta name="twitter:description"
        content="Learn more about More News, an independent digital journalism platform delivering trusted reporting, analysis and in-depth coverage of global and UK affairs.">
    <meta name="twitter:url" content="https://www.morenews.org/about.php">
    <meta name="twitter:image" content="https://www.morenews.org/images/morenews-about.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="css/style.css" as="style">
    <link rel="stylesheet" href="css/style.css">

    <!-- Favicon -->
    <link rel="icon" href="images/icon.svg">

    <!-- Schema -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News",
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/about.php#webpage",
      "url": "https://www.morenews.org/about.php",
      "name": "About More News | Independent Global Journalism Platform",
      "description": "Learn more about More News, an independent digital journalism platform delivering trusted reporting, analysis and in-depth coverage of global and UK affairs.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/morenews-about.webp",
        "width": 1200,
        "height": 630
      }
    }

  ]
}
</script>

</head>


<body>

  <!-- Header -->
  <?php include 'index-header.php'; ?>

  <div class="main-container">

    <!-- MAIN CONTENT -->
    <div class="story-wrapper">
      <div class="story-grid">

        <!-- LEFT CONTENT -->
        <div class="primary-feed">

          <!-- HERO IMAGE -->
          

          <!-- ARTICLE HEADER -->
          <div class="article-header">
            <div class="article-breadcrumb">
              <a href="index.php" class="crumb-link">Home</a> /
              <span class="crumb-current">About</span>
            </div>

            <h1 class="article-headline">About More News</h1>
          </div>
          <div class="image-wrapper">
            <img src="images/morenews-about.webp" alt="More News About">
          </div>

          <!-- ARTICLE CONTENT -->
          <div class="writer-block">
            <div class="story-text-wrap">

              <p>
                <strong>More News</strong> is an independent digital news platform committed to
                delivering accurate, thoughtful, and in-depth journalism on the issues shaping our world.
                We cover UK politics, global affairs, economics, climate, science, and social change with
                clarity and integrity.
              </p>

              <p>
                Founded on the principles of transparency and public accountability, More News
                aims to cut through noise and misinformation by focusing on verified reporting,
                contextual analysis, and human-centered storytelling.
              </p>

              <p>
                Our newsroom brings together journalists, analysts, and editors who believe journalism
                should inform, challenge power, and empower readers with facts—not outrage.
              </p>

              <p>
                We are not driven by political parties or corporate interests. Our mission is simple:
                to publish journalism that helps readers understand what is happening, why it matters,
                and how it affects their lives.
              </p>

              <p>
                More News is reader-focused, globally aware, and dedicated to upholding
                the highest standards of modern journalism.
              </p>

            </div>
          </div>

        </div>

        <!-- SIDEBAR -->
        <div class="side-railbox">
            <br>
          <div class="side-adunit">
            <img src="images/thatcapitalism.webp" alt="Sponsor">
          </div>

          <div class="side-socialpanel">
            <h4>Follow Us</h4>
            <ul>
              <a href="#"><i class="fab fa-facebook-f"></i></a>
              <a href="#"><i class="fab fa-instagram"></i></a>
              <a href="#"><i class="fab fa-linkedin-in"></i></a>
              <a href="#"><i class="fab fa-x-twitter"></i></a>
            </ul>
          </div>

        </div>

      </div>
    </div>
    <?php include 'index-footer.php'; ?>

  </div>

  <!-- Footer -->
  

  <!-- Scroll to top -->
  <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn">
    <i class="fa-solid fa-chevron-up"></i>
  </button>

  <script src="js/style.js"></script>

</body>
</html>
